/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.actions.*;

/*
* CONTEXT_ID refr0000 for refresh tree action
*/

public class RefreshTreeAction extends SelectionProviderAction
								implements ISelectionChangedListener
{
  private PDProjectExplorer fViewer;

   public RefreshTreeAction(PDProjectExplorer viewer)
  {
	super(viewer.getViewer(), UIPlugin.getResourceString("REFRESH"));
	setDescription(UIPlugin.getResourceString("REFRESH_THE_TREE"));
	fViewer = viewer;

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		this,
		UIPlugin.getPluginId()+".refr0000");
	
	setToolTipText(UIPlugin.getResourceString("REFRESH_TREE_TOOLTIP"));  
  }  
  public void run()
  {
		fViewer.getViewer().refresh();
  }  
  public void selectionChanged(IStructuredSelection selection)
  {
	setEnabled(true);
  }
  
  public void dispose() {
		
	  super.dispose();
		
	  fViewer = null;
  }

}
