/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;

/*
* CONTEXT_ID rgca0000 for run garbage collection action
*/

public class RunGCActionDelegate extends AbstractListenerActionDelegate {

	public void run(TRCAgentProxy fAgent, PDProjectExplorer fViewer) {

		if (!fAgent.isMonitored()) {
			MessageDialog.openInformation(
				UIPlugin.getActiveWorkbenchShell(),
				UIPlugin.getResourceString("TRACE_MSG"),
				UIPlugin.getResourceString("RUN_GC_INFO_"));
			return;
		}

		if (fAgent.getType().equals(TraceConstants.PROFILE_AGENT_TYPE)) {
			TRCProcessProxy process = fAgent.getProcessProxy();

			String hostName = process.getNode().getName();
			try {
				Node node = PDCoreUtil.profileConnect(hostName, String.valueOf(process.getNode().getPort()));
				if (node == null) {
					
					return;
				}

				Object instance = LoadersUtils.locateAgentInstance(fAgent);
				if(instance != null && instance instanceof Agent)
				{
					Agent a = (Agent)instance;
					
					CustomCommand command = new CustomCommand();

					command.setData("RUNGC");
					a.invokeCustomCommand(command);

				}

			}catch (Exception exc) {
				exc.printStackTrace();
			}
		}
	}

	/**
	 * @see AbstractProfileActionDelegate#isEnabledFor(Object)
	 */
	protected boolean isEnabledFor(Object element) {

		if (element == null)
			return false;

		if (element instanceof TRCAgentProxy) {
			
			TRCAgentProxy agent = (TRCAgentProxy) element;
			
			return (agent.getType().equals(TraceConstants.PROFILE_AGENT_TYPE)
			         && agent.isMonitored());
		}

		if (element instanceof TRCProcessProxy) {
			EList agents = ((TRCProcessProxy) element).getAgentProxies();

			for (int idx = 0; idx < agents.size(); idx++) {
				TRCAgentProxy agent = (TRCAgentProxy) agents.get(idx);
				if(agent.eIsProxy())
					continue;

				if (agent.getType().equals(TraceConstants.PROFILE_AGENT_TYPE)
				     && agent.isMonitored())
					return true;
			}
		}

		return false;
	}

	/**
	 * @see AbstractProfileActionDelegate#doAction(Object)
	 */
	public void doAction(Object object) throws Exception {

		if (object == null || !(object instanceof TRCAgentProxy))
			return;

		PDProjectExplorer fViewer = UIPlugin.getDefault().getViewer();
		if (fViewer == null) {
			MessageDialog.openInformation(
				UIPlugin.getActiveWorkbenchShell(),
				"title",
				"Action not available in current context");
			return;
		}

		run((TRCAgentProxy) object, fViewer);
	}

}
