/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.internal.execution.local.control.*;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;

/*
* CONTEXT_ID atha0000 for attach popup action
*/

public class TerminateProcessActionDelegate extends AbstractListenerActionDelegate {

	public void run(Object obj, PDProjectExplorer fViewer) {

	TRCProcessProxy process = null;
	
	if(obj instanceof TRCAgentProxy)
	   process = ((TRCAgentProxy) obj).getProcessProxy();
	else
	  process = (TRCProcessProxy)obj;
	     
	String title = UIPlugin.getResourceString("TRACE_MSG");	
	String msg = UIPlugin.getResourceString("TERMINATE_Q");
 	
	if(! MessageDialog.openQuestion(fViewer.getShell(), title, msg))
		return;
		
		String host = process.getNode().getName();
		Node node = PDCoreUtil.profileConnect(host, String.valueOf(process.getNode().getPort()));
		if(node == null)
			return;
		
		Process p = node.getProcess(String.valueOf(process.getPid()));
		
		try {
			if(p != null && p.isActive())
			{
				node.killProcess(p);
			}
		}
		catch(NotConnectedException exc1)
		{
			exc1.printStackTrace();
		}		
		catch(InactiveProcessException exc2)
		{
			exc2.printStackTrace();
		}

		ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
		event.setSource(process);
		event.setType(ProfileEvent.TERMINATE);
		UIPlugin.getDefault().notifyProfileEventListener(event);

	}


	/**
	 * @see AbstractProfileActionDelegate#enableForMultiSelection()
	 */
	protected boolean enableForMultiSelection() {
		return false;
	}

	/**
	 * @see AbstractProfileActionDelegate#isEnabledFor(Object)
	 */
	protected boolean isEnabledFor(Object element) {

		if (element != null)
		{
			if((element instanceof TRCAgentProxy && ((TRCAgentProxy) element).isActive())
			   || (element instanceof TRCProcessProxy && ((TRCProcessProxy) element).isActive()))
			
			return true;
		}

		return false;

	}

	/**
	 * @see AbstractProfileActionDelegate#doAction(Object)
	 */
	public void doAction(Object object) throws Exception {

		if (object == null)
			return;

		PDProjectExplorer fViewer = UIPlugin.getDefault().getViewer();
		if (fViewer == null) {
			MessageDialog.openInformation(
				UIPlugin.getActiveWorkbenchShell(),
				"title",
				"Action not available in current context");
			return;
		}

		run(object, fViewer);
	}
}
