/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import java.util.*;

import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.jdt.core.*;

/**
 * The execution arguments for running a Java VM. The execution arguments are
 * separated into two parts: arguments to the VM itself, and arguments to the Java 
 * main program.
 */
public class TraceArguments
{
	private String fHostName;		
	private String fClassName;
	private String fClassPath;
	private String fParameters;
	private String fVMArgs;
	private int fPortNumber;
	private ArrayList fEnvionmentVariable;
	
	private String fTraceMode;

	private Date fTimestamp;
	private String fId = "";

	private TRCAgentProxy fAgent;
	private TRCProcessProxy fProcess;
	private IType           fType; //launch from workbench
	private String   fPath;
	private String   fLocation; //process home directory
	private String   profileFile = null; //null when not to profile file

	/**
	 * Creates a new execution arguments object.
	 *
	 */
	public TraceArguments(TRCAgentProxy agent, String mode)
	{
		fAgent = agent;
		fProcess = agent.getProcessProxy();
		fTraceMode = mode;
		fTimestamp = new Date();
	}
	/**
	 * Creates a new execution arguments object.
	 *
	 */
	public TraceArguments(TRCProcessProxy process, String mode)
	{
		fProcess = process;
		fTraceMode = mode;
		fTimestamp = new Date();
	}
	/**
	 * Creates a new execution arguments object.
	 *
	 */
	public TraceArguments(String className)
	{
		fClassName = className;
		fTimestamp = new Date();
	}
	/**
	 * Creates a new execution arguments object.
	 *
	 */
	public TraceArguments(IType type)
	{
		fType = type;
		setClassName(type.getFullyQualifiedName());
		fTimestamp = new Date();
	}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 6:13:09 PM)
 * @return com.ibm.etools.perftrace.TRCAgent
 */
public TRCAgentProxy getAgent() {
	return fAgent;
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 3:32:40 PM)
 * @return java.lang.String
 */
public String getClassName()
{
	if(fType != null)
	  return fType.getFullyQualifiedName();
	  
	if(fProcess == null)
		return fClassName;

	return fProcess.getName();
}

public ArrayList getEnvironmentVariable()
{
	return fEnvionmentVariable;
}

/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 3:32:40 PM)
 * @return java.lang.String
 */
public String getClassPath()
{
	return fClassPath;
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 3:32:40 PM)
 * @return java.lang.String
 */
public String getHostName()
{
	if(fProcess == null)
		return fHostName;

	return fProcess.getNode().getName();
}

public int getPortNumber()
{
	return fPortNumber;
}

/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 4:18:31 PM)
 * @return java.lang.String
 */
public String getId()
{
	if(fAgent != null)
		return fAgent.getRuntimeId();
	
	if(fProcess != null)
		return fProcess.getRuntimeId();		

	return fId;	
}
/**
 * Insert the method's description here.
 * Creation date: (9/7/2001 5:41:24 PM)
 */
public String getLocation()
{
	if(fProcess != null)
	   return fProcess.getLocation();
	else if(fAgent != null)   
	   return fAgent.getProcessProxy().getLocation();
	   
	return fLocation;
}
	/**
	 * Returns the program arguments.
	 *
	 * @return the program arguments
	 */
	public String getParameters()
	{
		return fParameters;
	}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 5:16:51 PM)
 * @return java.lang.String
 */
public String getPath() {
	return fPath;
}
/**
 * Insert the method's description here.
 * Creation date: (5/2/2001 12:41:34 PM)
 * @return com.ibm.etools.perftrace.TRCProcessProxy
 */
public TRCProcessProxy getProcess() {
	return fProcess;
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 3:24:13 PM)
 * @return Date
 */
public Date getTimestamp() {
	return fTimestamp;
}
/**
 * Insert the method's description here.
 * Creation date: (8/13/2001 9:51:25 AM)
 * @return org.eclipse.jdt.core.IType
 */
public IType getType() {
	return fType;
}
	/**
	 * Returns the program arguments.
	 *
	 * @return the program arguments
	 */
	public String getVMArguments()
	{
		return fVMArgs;
	}
/**
 * Insert the method's description here.
 * Creation date: (8/13/2001 10:08:06 AM)
 * @param agent com.ibm.etools.perftrace.TRCAgent
 */
public void setAgent(TRCAgentProxy agent)
{
	fAgent = agent;
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 3:11:37 PM)
 * @param name java.lang.String
 */
public void setClassName(String name)
{
	fClassName = name;
}


public void setEnvironmentVariable(ArrayList envVar)
{
	fEnvionmentVariable = envVar;
}

/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 3:11:37 PM)
 * @param name java.lang.String
 */
public void setClassPath(String name)
{
	fClassPath = name;
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 3:11:37 PM)
 * @param name java.lang.String
 */
public void setHostName(String name)
{
	fHostName = name;		
}

public void setPortNumber(int portNumber)
{
	fPortNumber = portNumber;		
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 4:16:37 PM)
 * @param id java.lang.String
 */
public void setId(String id)
{
	fId = id;
}
/**
 * Insert the method's description here.
 * Creation date: (9/7/2001 5:40:51 PM)
 * @param location java.lang.String
 */
public void setLocation(String location)
{
	fLocation = location;
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 3:11:37 PM)
 * @param name java.lang.String
 */
public void setParameters(String name)
{
	fParameters = name;
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 5:16:22 PM)
 * @param path java.lang.String
 */
public void setPath(String path)
{
	fPath = path;
}
/**
 * Insert the method's description here.
 * Creation date: (8/13/2001 10:08:40 AM)
 * @param process com.ibm.etools.perftrace.TRCProcessProxy
 */
public void setProcess(TRCProcessProxy process)
{
	fProcess = process;

}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 3:11:37 PM)
 * @param name java.lang.String
 */
public void setTraceMode(String name)
{
	fTraceMode = name;
}
/**
 * Insert the method's description here.
 * Creation date: (8/13/2001 10:09:18 AM)
 * @param type org.eclipse.jdt.core.IType
 */
public void setType(IType type)
{
	fType = type;
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 3:11:37 PM)
 * @param name java.lang.String
 */
public void setVMArguments(String name)
{
	fVMArgs = name;
}
/**
 * Insert the method's description here.
 * Creation date: (5/1/2001 5:11:09 PM)
 */
public String toString()
{
	if(fProcess != null)
		return fProcess.getName();
	
	return fClassName;
	
	
}

	/**
	 * Determine if profile data is to a file.
	 */
	public boolean isToProfileFile()
	{
		return !(profileFile==null || profileFile.trim().equals(""));
	}
	
	/**
	 * Returns the profileFile.
	 * @return String
	 */
	public String getProfileFile() {
		return profileFile;
	}

	/**
	 * Sets the profileFile.
	 * @param profileFile The profileFile to set
	 */
	public void setProfileFile(String profileFile) {
		this.profileFile = profileFile;
	}

}
