/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.*;

import org.eclipse.emf.common.util.*;
import org.eclipse.hyades.internal.execution.local.common.*;
import org.eclipse.hyades.internal.execution.local.control.*;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.security.util.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.ui.internal.core.*;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.jface.preference.*;
import org.eclipse.jface.wizard.*;
import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
/*
* CONTEXT_ID powp0000 for profile options wizard page
*/
public class AgentOptionsPage extends WizardPage{
	protected TraceProfileOptionsUI _optionsUI;
	protected String _type;

	public AgentOptionsPage(String name, String type) {
		super(name);
		_type = type;
		setTitle(UIPlugin.getResourceString("AGENT_OPT_WIZARD_TITLE"));
		setDescription(UIPlugin.getResourceString("AGENT_WIZARD_DESCR"));
	}
	public void createControl(Composite parent) {
		Label label;

		Composite content = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 5;
		content.setLayout(layout);
		GridData gd = GridUtil.createFill();
		gd.widthHint = 500;
		gd.heightHint = 400;
		content.setLayoutData(gd);

		_optionsUI = new TraceProfileOptionsUI();
		_optionsUI.createControl(content);
		_optionsUI.setWizardPage(this);

		setControl(content);

		initializeValues();

		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			parent,
			UIPlugin.getPluginId() + ".powp0000");
	}
	public boolean finish() {
		
		_optionsUI.storeValues();
		return true;

	}
	/**
	 * Insert the method's description here.
	 * Creation date: (8/16/2001 10:31:47 AM)
	 * @return java.util.Vector
	 */
	public Vector getOptions() {
		return _optionsUI.getOptions();
	}
	/**
	 * Initializes states of the controls from the preference store.
	 */
	private void initializeValues() {
		_optionsUI.enableButtons();

		if (getWizard() instanceof RelaunchWizard) {
			((RelaunchWizard) getWizard()).setAgentOptions();
		}

	}
	public void initializeValues(EList options) {

	 	 _optionsUI.setExecutionBoundary(false);
		 
		 //set default depth
		 IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
		 _optionsUI.setCollectionDepth(store.getString(TraceConstants.COLLECT_DEPTH));
		
		if (options != null)
		{
			Iterator i = options.iterator();
			while (i.hasNext())
			{
				TRCOption option = (TRCOption)i.next();
				
				if(option.getKey().equals(Options.OPTION_STACK_INFORMATION))
				{
					if(option.getValue().equals(Options.OPTION_VALUE_BOUNDARYANDCONTIGUOUS))
					{
					   _optionsUI.setExecutionBoundary(true);
					   _optionsUI.setExecution(true);
					}
					else if(option.getValue().equals(Options.OPTION_VALUE_CONTIGUOUS))
					{
						_optionsUI.setExecution(true);
					}
					else if(option.getValue().equals(Options.OPTION_VALUE_NONE))
					{
						_optionsUI.setExecution(false);
					} 					 
				}
				else if(option.getKey().equals(Options.OPTION_TRACE_MODE))
				{
					if(option.getValue().equals(Options.OPTION_VALUE_NOOBJECTCORRELATION))
					{
						_optionsUI.setHeap(false);
					}
					if(option.getValue().equals(Options.OPTION_VALUE_DEFAULT))
					{
						 _optionsUI.setHeap(true);
					}
				}					
				else if(option.getKey().equals(Options.OPTION_BOUNDARY_DEPTH))
				{
					_optionsUI.setCollectionDepth(option.getValue());
					_optionsUI.setExecutionBoundary(true);
					_optionsUI.setExecution(true);
				}
			}			
		}
		
		_optionsUI.enableBtnGroup();
	}

	/**
	 * Determine whether this page should be enabled.
	 */
	public void setVisible(boolean visible) {
		super.setVisible(visible);

		if (visible) {
			Vector aList = getAgentsList();
			if (aList != null && !hasProfilingAgent(aList)) {
				this.getControl().setEnabled(false);
				this.getControl().setVisible(false);
				this.setDescription(UIPlugin.getResourceString("STR_OPTION_IGNORED"));

			} else {
				this.getControl().setEnabled(true);
				this.getControl().setVisible(true);
				this.setDescription(UIPlugin.getResourceString("AGENT_WIZARD_DESCR"));
			}
		}
	}
	/**
	 * Get the list of agents depending on the type of wizard.
	 */
	private Vector getAgentsList() {
		DoubleCTree agentList = null;
		Vector aList = null;

		if (_type.equals(TraceConstants.ATTACH_LOCAL_WIZARD)) {
			agentList = ((AttachLocalWizard) getWizard()).getAgentList();
		} else if (_type.equals(TraceConstants.ATTACH_REMOTE_WIZARD)) {
			agentList = ((AttachRemoteWizard) getWizard()).getAgentList();
		}

		if (agentList != null) {
			aList = agentList.getSelectedAgents();
		}

		return aList;
	}
	/**
	 * Return true if have at least one Profiling Agent.
	 */
	private boolean hasProfilingAgent(Vector agents) {
		for (int idx = 0; idx < agents.size(); idx++) {
			Agent agent = (Agent) agents.elementAt(idx);
			if (agent.getType() != null
				&& agent.getType().equals(TraceConstants.PROFILE_AGENT_TYPE)
				&& !agent.getName().equals(TraceConstants.J2EE_AGENT_NAME)) {
				return true;
			}
		}
		return false;
	}
	
}
