/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Vector;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class LaunchLocalWizard
	extends Wizard
	implements INewWizard, IRunnableWithProgress {

	private ProcessLocalDataPage fProcessPage;
	private DestinationFolderPage fFolderPage;
	private ProfileOptionsPage fProfilePage;
	private AgentOptionsPage fOptionsPage;
	private AgentCollectionsPage fCollectionsPage;
	private IStatus error;
	private boolean success = true;
	private boolean isProfilingEnabled = UIPlugin.getDefault().getPreferenceStore().getBoolean(TraceConstants.PROF_OPTION_KEY);

	public LaunchLocalWizard() {
		setNeedsProgressMonitor(true);
	}
	public void addPages() {
		setWindowTitle(UIPlugin.getResourceString("LAUNCH_JAVA_APP_TITLE"));
		fProcessPage = new ProcessLocalDataPage("processData");
		fFolderPage = new DestinationFolderPage("folderPage");
		
		if(isProfilingEnabled)
		{
			fProfilePage = new ProfileOptionsPage("profilePage", TraceConstants.LAUNCH_LOCAL_WIZARD);
			fOptionsPage = new AgentOptionsPage("agentPage", TraceConstants.LAUNCH_LOCAL_WIZARD);
			fCollectionsPage = new AgentCollectionsPage("collentionsPage",TraceConstants.LAUNCH_LOCAL_WIZARD);
			
			fProfilePage.setImageDescriptor(
				UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_LAUNCH));
			fOptionsPage.setImageDescriptor(
				UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_LAUNCH));
			fCollectionsPage.setImageDescriptor(
				UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_LAUNCH));
			
		}

		addPage(fProcessPage);
		addPage(fFolderPage);
		
		if(isProfilingEnabled)
		{		
			addPage(fProfilePage);
			addPage(fOptionsPage);
			addPage(fCollectionsPage);
		}

		fFolderPage.setImageDescriptor(
			UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_LAUNCH));
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (8/16/2001 10:30:42 AM)
	 * @return java.util.Vector
	 */
	public ArrayList getFilterSet() {
		return fProfilePage.getFilterSet();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (8/16/2001 10:02:07 AM)
	 * @return com.ibm.etools.pd.core.wizard.DestinationFolderPage
	 */
	public DestinationFolderPage getFolderPage() {
		return fFolderPage;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (8/16/2001 10:30:42 AM)
	 * @return java.util.Vector
	 */
	public Vector getOptions() {
		
		if(isProfilingEnabled)
		{
			Vector options = fOptionsPage.getOptions();
			Vector collections = fCollectionsPage.getOptions();
			
			options.addAll(collections);  
			
			return options;
		}
		
		return new Vector();
	}
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		setDefaultPageImageDescriptor(
			UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_MON_PROP));

	}
	public boolean performFinish() {
		
		if (!fFolderPage.getFile().equals("") && !PDCoreUtil.isPathExists(fFolderPage.getFile()))
		{
			if (!PDCoreUtil.createDirectoryMessage(fFolderPage.getFile(),getShell()))
				return false;
		}
		
		IRunnableWithProgress op = new WorkspaceModifyDelegatingOperation(this);
		try {
			getContainer().run(false, true, op);
		} catch (InvocationTargetException e) {
			MessageDialog.openError(
				getShell(),
				"Error",
				e.getTargetException().getMessage());
			return false;
		} catch (InterruptedException e) {
			return false;
		}

		return success;
	}
	public void run(IProgressMonitor mon) {
		
		if(isProfilingEnabled)	
		{	
        	fProfilePage.finish();
	        fOptionsPage.finish();        	
		}
        		
		success = fFolderPage.finish();
        
		if (success)
			success = fProcessPage.finish(
				fFolderPage.getProject(),
				fFolderPage.getMonitor(),
				fFolderPage.getFile());

		if (!success) {
			error =
				new Status(
					Status.ERROR,
					UIPlugin.getPluginId(),
					IResourceStatus.INTERNAL_ERROR,
					UIPlugin.getResourceString("ERROR_CREATING_ERROR_"),
					new Exception());
		}
	}
	
	public boolean isProfilingEnabled()
	{
		return isProfilingEnabled;
	}
	

}
