/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.io.*;
import java.net.*;
import java.util.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.emf.common.util.*;
import org.eclipse.hyades.internal.execution.local.control.*;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.internal.core.*;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.jdt.core.*;
import org.eclipse.jface.wizard.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

/*
* CONTEXT_ID rrdp0000 for process relaunch wizard page
*/

public class RelaunchDataPage  extends WizardPage
									implements ModifyListener
{
	private LaunchProcessUI _processUI;
	private String          _hostName;
	private int             _portNumber;
	
	private String          _selectedProject;
	private String	        _selectedMonitor;
	private String          _profileFile;
	
public RelaunchDataPage(String name)
  {
	super(name);
	setTitle(UIPlugin.getResourceString("PROCESS_WIZARD_TITLE"));
	setDescription(UIPlugin.getResourceString("RELAUNCH_CLASS_DESC"));
	
	setImageDescriptor(UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_LAUNCH)); 
  }    
  public void createControl(Composite parent)
  {
	GridLayout layout;
	
	Composite pGroup = new Composite(parent, SWT.NONE);
	layout = new GridLayout();
	layout.numColumns = 1;
	layout.marginWidth = 10;
	pGroup.setLayout(layout);
	pGroup.setLayoutData(GridUtil.createHorizontalFill());
	_processUI = new LaunchProcessUI(); 
	Composite systemControl = _processUI.createControl(pGroup);
	
	_processUI.getClassUI().addModifyListener(this);
	_processUI.setShell(getShell());
	
	setPageComplete(false);
		
	setControl(pGroup);

	initializePage();
	
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		this.getControl(),
		UIPlugin.getPluginId()+".rrdp0000");
  } 
  
    public boolean finish(String selectedProject, String selectedMonitor, String profileFile)
  {
  	_selectedProject = selectedProject;
  	_selectedMonitor = selectedMonitor;
  	_profileFile = profileFile;
  	return finish();
  	
  }
   
  private boolean success = true; 
  public boolean finish()  
  {
  	
	  _portNumber =	Integer.parseInt(((RelaunchWizard)getWizard()).getNodeUI().getPortNumberUI().getText().trim());
  	
	  TraceArguments trace = new TraceArguments(_processUI.getClassName());
	  if (_profileFile!=null || _profileFile.trim().equals(""))
	  	trace.setProfileFile(_profileFile);	  
	  trace.setHostName(_hostName);
	  trace.setClassPath(_processUI.getClassPath());
	  trace.setParameters(_processUI.getParametersUI().getText().trim());
	  trace.setVMArguments(_processUI.getVMArgs().trim());
	  trace.setPortNumber(_portNumber);
	  trace.setEnvironmentVariable(_processUI.getEnvData());

	  TRCProcessProxy process = ((RelaunchWizard)getWizard()).getProcess();
	  if(process != null)
	  {
	     trace.setLocation(process.getLocation());
	  }
	     
	  ArrayList filters = new ArrayList();

      if(((RelaunchWizard)getWizard()).isProfilingEnabled())
      {	  
		ArrayList filterSet = ((RelaunchWizard)getWizard()).getFilterSet();
		for(int idx=0; idx<filterSet.size(); idx++)
		{
			FilterSetElement elems = (FilterSetElement)filterSet.get(idx);
			if(elems.getEnabled())
			{
				UIPlugin.getDefault().getPluginPreferences().setValue(TraceConstants.ACTIVE_FILTER_NAME, elems.getName());				
	            filters = elems.getChildren();
				break;
			}
		}
      }
	  
	   success = PDCoreUtil.launchTrace(trace
		    , filters
		    , ((RelaunchWizard)getWizard()).getOptions()
   		   , _selectedProject
		   , _selectedMonitor);		    

		if(trace.getType()!= null)
		{
		   UIPlugin.getDefault().getTraceManager().registerTrace(trace.getType());
		}
	  
	  return success;
  }  
 /**
 * Insert the method's description here.
 * Creation date: (11/10/2000 11:00:57 AM)
 * @return java.lang.String
 */
public String getClassName() {
	return _processUI.getClassName();
}/**
 * Insert the method's description here.
 * Creation date: (11/10/2000 11:00:57 AM)
 * @return java.lang.String
 */ 
public String getClassPath()
{
	return _processUI.getClassPath();  
}
/**
 * Insert the method's description here.
 * Creation date: (8/13/2001 10:24:21 AM)
 * @param type org.eclipse.jdt.core.IType
 */
private void initializeFromWorkbench(IType type)
{
	try {               
		IJavaProject project = type.getJavaProject();

		//classname
		String fileName=type.getElementName();
		String classname = type.getFullyQualifiedName();

		//classpath   
		IWorkspace workbench = UIPlugin.getPluginWorkbench();      
		IPath wpath = workbench.getRoot().getLocation();	
		String prjpath = project.getProject().getLocation().toOSString();

		String classpath="";
		if(!prjpath.startsWith(wpath.toOSString()))	
			 classpath = prjpath+File.pathSeparator;	

		IClasspathEntry[] path = project.getResolvedClasspath(true);                 
		if(path != null)
		{
			for(int j=0; j<path.length; j++)
			{
				IClasspathEntry entry = JavaCore.getResolvedClasspathEntry(path[j]);
				if(entry != null)
				{						
					IPath cpath = entry.getPath();

					if(!classpath.equals(""))
					  classpath += "\n";
					if(cpath.getDevice() != null)
						classpath += cpath.toOSString() + File.pathSeparator;
					else
						classpath += wpath.append(cpath).toOSString() + File.pathSeparator;
				}
			}
		}                           

		//program arguments
		String args = "";
		String vmArgs = "";
		
		_processUI.getClassPathUI().setText(classpath.trim());
		_processUI.getParametersUI().setText(args.trim());
		_processUI.getVMArgsUI().setText(vmArgs.trim());
	}
	catch(Exception exc)
	{
		exc.printStackTrace();
	} 

	_processUI.enable(false, true, false, true, true);
	
}
/**
 * Insert the method's description here.
 * Creation date: (8/10/2001 3:28:28 PM)
 */
private void initializePage()
{
	Object sel = ((RelaunchWizard)getWizard()).getSelection();

	if(sel == null)
	  return;

	IType type = null; 
	TRCProcessProxy process = null;
	TRCAgentProxy agent = null;

	if(sel instanceof IType)
	{
		type = (IType) sel;
		TraceArguments trace = UIPlugin.getDefault().getTraceManager().findTrace(type);
		if(trace != null)
		{
			process = trace.getProcess();
			agent = trace.getAgent();
		}
	}
	else if(sel instanceof TRCAgentProxy)
	{
		agent = (TRCAgentProxy)sel;
		process = agent.getProcessProxy();
	}
	else if(sel instanceof TRCProcessProxy)
	   process = (TRCProcessProxy)sel;

	if(type != null)
	{
	    initializeFromWorkbench(type);
   		_processUI.getClassUI().setText(type.getFullyQualifiedName());
	}

	if(process == null)
	  return;
		
	TRCNode node = process.getNode();   

	if(type == null)
	{
		String name = process.getName(); 
		_processUI.getClassUI().setText(name);
		
		if(process.getClasspath() != null)
			_processUI.getClassPathUI().setText(process.getClasspath());
		if(process.getParameters() != null)
			_processUI.getParametersUI().setText(process.getParameters());
		if(process.getVmArguments() != null)		
			_processUI.getVMArgsUI().setText(process.getVmArguments());
		if(process.getEnvironmentVariables() != null)
			setEnvironment(_processUI,process);
	}

	boolean isLocalHost = false;
	_hostName=node.getName();
	
	try {
		  Node fnode = NodeFactory.createNode(_hostName);
		 if(fnode.getInetAddress().equals(InetAddress.getLocalHost()))
		 {
			 isLocalHost = true;
		 }		 
	}
	catch(UnknownHostException exc)
	{		  
	}
	
	_processUI.enable(false, true, false, isLocalHost, true);
}
/**
 * Sent when the text is modified.
 *
 * @param e an event containing information about the modify
 */
public void modifyText(ModifyEvent e)
{
	setPageComplete(!_processUI.getClassUI().getText().trim().equals(""));
}

public void setEnvironment(LaunchProcessUI processUI, TRCProcessProxy process)
{
	ArrayList envData = new ArrayList();
	
	EList environments = process.getEnvironmentVariables();
	for (int i=0;i<environments.size();i++)
	{
		TRCEnvironmentVariable env = (TRCEnvironmentVariable)(environments.get(i));
		EnvTableElement envTblElement = new EnvTableElement(env.getName(),env.getValue());
		envData.add(envTblElement);
	}

	processUI.setEnvData(envData);
}

}
