/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.*;

import org.eclipse.core.runtime.*;
import org.eclipse.emf.common.util.*;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.internal.core.*;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.jdt.core.*;
import org.eclipse.jface.dialogs.*;
import org.eclipse.jface.operation.*;
import org.eclipse.jface.preference.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.jface.wizard.*;
import org.eclipse.ui.*;
import org.eclipse.ui.actions.*;

public class RelaunchWizard
	extends Wizard
	implements INewWizard, IRunnableWithProgress {
	private RelaunchDataPage fProcessPage;
	private DestinationFolderPage fFolderPage;
	private ProfileOptionsPage fProfilePage;
	private AgentOptionsPage fOptionsPage;
	private AgentCollectionsPage fCollectionsPage;
	private Object fSelection;
	private TRCProcessProxy fProcess;
	private RelaunchNodeWizardPage fHostPage;
	private boolean isProfilingEnabled = UIPlugin.getDefault().getPreferenceStore().getBoolean(TraceConstants.PROF_OPTION_KEY);

	public RelaunchWizard(Object selection) {
		super();
		setNeedsProgressMonitor(true);
		fSelection = selection;
	}
	public void addPages() {
		setWindowTitle(UIPlugin.getResourceString("RELAUNCH_DLG_TITLE"));
		fHostPage = new RelaunchNodeWizardPage("nodeData");
		fProcessPage = new RelaunchDataPage("processData");
		fFolderPage = new DestinationFolderPage("folderPage");

		addPage(fProcessPage);
		addPage(fHostPage);		
		addPage(fFolderPage);
		
		if(isProfilingEnabled)
		{
			fProfilePage = new ProfileOptionsPage("profilePage", TraceConstants.RELAUNCH_WIZARD);
			fOptionsPage = new AgentOptionsPage("agentPage", TraceConstants.RELAUNCH_WIZARD);
			fCollectionsPage = new AgentCollectionsPage("collentionsPage",TraceConstants.LAUNCH_LOCAL_WIZARD);
			
			addPage(fProfilePage);
			addPage(fOptionsPage);
			addPage(fCollectionsPage);

			fProfilePage.setImageDescriptor(
				UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_LAUNCH));
			fOptionsPage.setImageDescriptor(
				UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_LAUNCH));
			fCollectionsPage.setImageDescriptor(
				UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_LAUNCH));
			
		}


		fHostPage.setImageDescriptor(
			UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_LAUNCH));
		fFolderPage.setImageDescriptor(
			UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_LAUNCH));
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (8/16/2001 12:58:14 PM)
	 * @return java.util.Vector
	 */

	public TraceNodeUI getNodeUI() {
		return fHostPage.getNodeUI();
	}
	public ArrayList getFilterSet() {
		return fProfilePage.getFilterSet();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (8/16/2001 1:20:41 PM)
	 * @return com.ibm.etools.pd.core.ui.TraceLocationUI
	 */
	public TraceLocationUI getLocation() {
		return fFolderPage.getLocation();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (8/16/2001 10:30:42 AM)
	 * @return java.util.Vector
	 */
	public Vector getOptions() {
		
		if(isProfilingEnabled)
		{
			Vector options = fOptionsPage.getOptions();
			Vector collections = fCollectionsPage.getOptions();
			
			options.addAll(collections);  
			
			return options;
		}
		
		return new Vector();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (9/7/2001 5:48:21 PM)
	 * @return com.ibm.etools.perftrace.TRCProcessProxy
	 */
	public TRCProcessProxy getProcess() {
		return fProcess;
	}

	public TRCNode getNode() {
		initfProcess();
		return fProcess.getNode();
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (8/10/2001 3:23:07 PM)
	 * @return java.lang.Object
	 */
	public Object getSelection() {
		return fSelection;
	}
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		setDefaultPageImageDescriptor(
			UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_MON_PROP));
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (8/16/2001 2:09:08 PM)
	 */
	private void initfProcess() {
		if (fSelection instanceof IType) {
			IType type = (IType) fSelection;
			TraceArguments trace =
				UIPlugin.getDefault().getTraceManager().findTrace(type);
			if (trace != null) {
				fProcess = trace.getProcess();
			}
		} else if (fSelection instanceof TRCAgentProxy) {
			fProcess = ((TRCAgentProxy) fSelection).getProcessProxy();
		} else if (fSelection instanceof TRCProcessProxy)
			fProcess = (TRCProcessProxy) fSelection;
	}

	public void initializeLocation() {
		initfProcess();
		TraceLocationUI locationUI = getLocation();
		IPath path =
			new Path(TString.resourcePath(fProcess.eResource().getURI()));
		locationUI.setLocation(
			path.uptoSegment(path.segmentCount() - 1).toString());
		locationUI.setMonitor(fProcess.getNode().getMonitor().getName());

	}

	public boolean performFinish() {
		if (!fFolderPage.getFile().equals("") && !PDCoreUtil.isPathExists(fFolderPage.getFile()))
		{
			if (!PDCoreUtil.createDirectoryMessage(fFolderPage.getFile(),getShell()))
				return false;
		}
		
		IRunnableWithProgress op = new WorkspaceModifyDelegatingOperation(this);
		try {
			getContainer().run(false, true, op);
		} catch (java.lang.reflect.InvocationTargetException e) {
			MessageDialog.openError(
				getShell(),
				"Error",
				e.getTargetException().getMessage());
			return false;
		} catch (InterruptedException e) {
			return false;
		}

		return true;
	}
	public void run(IProgressMonitor mon) {
		
		boolean success = fFolderPage.finish();
		
		if(isProfilingEnabled)
		{
	    	fProfilePage.finish();	
			fOptionsPage.finish();	
		}

		if (success)
			success =
				fProcessPage.finish(
					fFolderPage.getProject(),
					fFolderPage.getMonitor(),
					fFolderPage.getFile());

	}
	/**
	 * Insert the method's description here.
	 * Creation date: (8/16/2001 1:25:30 PM)
	 */
	public void setAgentFilters() {
		if (fSelection == null)
			return;

		TRCProcessProxy process = null;
		TRCAgentProxy agent = null;

		if (fSelection instanceof IType) {
			IType type = (IType) fSelection;
			TraceArguments trace =
				UIPlugin.getDefault().getTraceManager().findTrace(type);
			if (trace != null) {
				process = trace.getProcess();
				agent = trace.getAgent();
			}
		} else if (fSelection instanceof TRCAgentProxy) {
			agent = (TRCAgentProxy) fSelection;
			process = agent.getProcessProxy();
		} else if (fSelection instanceof TRCProcessProxy)
			process = (TRCProcessProxy) fSelection;

		TRCAgentProxy fAgent = null;
		if (agent != null)
			fAgent = agent;
		else {
			Iterator agents = process.getAgentProxies().iterator();
			while (agents.hasNext()) {
				TRCAgentProxy a = (TRCAgentProxy) agents.next();
				if(a.eIsProxy())
					continue;
				if (a.getType().equals(TraceConstants.PROFILE_AGENT_TYPE)) {
					fAgent = a;
					break;
				}
			}

		}

		if (fAgent == null) {
			IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
			if (store.getBoolean(TraceConstants.PROF_OPTION_KEY)) {
				String filters =
					store.getString(TraceConstants.FILTERS_SET_KEY);
				fProfilePage.setFilters(filters);
			}
			return;
		}

		fProfilePage.setFilters(UIPlugin.getDefault().getPreferenceStore().getString(TraceConstants.FILTERS_SET_KEY));	

		EList configs = fAgent.getConfigurations();
		Iterator it = configs.iterator();
		if (it.hasNext()) {
			TRCConfiguration config = (TRCConfiguration) it.next();
			EList filters = config.getFilters();
			
			ArrayList list = new ArrayList();

			if (filters != null) {
				Iterator i = filters.iterator();
				while (i.hasNext()) {
					TRCFilter filter = (TRCFilter) i.next();
					String method = filter.getOperation();
					if (method !=null)
					{
						list.add(new FilterTableElement(
									filter.getPattern(), method
									, filter.getMode()));
					}					
					else
					{
						list.add(new FilterTableElement( 
							filter.getPattern(),
							"*",
							filter.getMode()));
					}
				}
			}
			
			ArrayList filterSets = fProfilePage.getFilterSet();
			for(int i=0; i<filterSets.size(); i++)
			{
				FilterSetElement elem = (FilterSetElement)filterSets.get(i);
				if(elem.getName().equals(config.getName()))
				{
					fProfilePage.alterFilterSetChildren(elem, list);
					break;
				}
			}
		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (8/16/2001 1:25:30 PM)
	 */
	public void setAgentOptions() {
		if (fSelection == null)
			return;

		TRCProcessProxy process = null;
		TRCAgentProxy agent = null;

		if (fSelection instanceof IType) {
			IType type = (IType) fSelection;
			TraceArguments trace =
				UIPlugin.getDefault().getTraceManager().findTrace(type);
			if (trace != null) {
				process = trace.getProcess();
				agent = trace.getAgent();
			}
		} else if (fSelection instanceof TRCAgentProxy) {
			agent = (TRCAgentProxy) fSelection;
			process = agent.getProcessProxy();
		} else if (fSelection instanceof TRCProcessProxy)
			process = (TRCProcessProxy) fSelection;

		TRCAgentProxy fAgent = null;
		if (agent != null)
			fAgent = agent;
		else {
			Iterator agents = process.getAgentProxies().iterator();
			while (agents.hasNext()) {
				TRCAgentProxy a = (TRCAgentProxy) agents.next();
				if(a.eIsProxy())
					continue;
				if (a.getType().equals(TraceConstants.PROFILE_AGENT_TYPE)) {
					fAgent = a;
					break;
				}
			}

		}

		if (fAgent == null)
			return;

		EList configs = fAgent.getConfigurations();
		Iterator it = configs.iterator();
		if (it.hasNext()) {
			TRCConfiguration config = (TRCConfiguration) it.next();
			EList options = config.getOptions();
			fOptionsPage.initializeValues(options);
			fCollectionsPage.initializeValues(options);
		}
	}
	
	public boolean isProfilingEnabled()
	{
		return isProfilingEnabled;
	}

}
