package org.eclipse.hyades.logging.parsers;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

public final class ParserConstants {
	
    public final static String HYADES_VERSION = "0.2.0";

    public final static String REMOTE_LOG_LOADER_AGENT_NAME = "Remote Log Loader IRemoteEntity";

    public final static String REMOTE_LOG_LOADER_ERROR_AGENT_NAME = "Remote Log Loader Error IRemoteEntity";

    public final static String REMOTE_LOG_LOADER_RAC_APPLICATION = "RemoteLogParserLoader";

    public final static String REMOTE_LOG_LOADER_CLASS = "com.ibm.etools.logging.parsers.RemoteLogParserLoader";

    public final static String APACHE_HTTP_SERVER_ERROR_LOG_PARSER_NAME = "Apache HTTP Server V1.3.26 error log";
    public final static String APACHE_HTTP_SERVER_ERROR_LOG_PARSER_VERSION = HYADES_VERSION;

    public final static String APACHE_HTTP_SERVER_ACCESS_LOG_PARSER_NAME = "Apache HTTP Server V1.3.26 access log";
    public final static String APACHE_HTTP_SERVER_ACCESS_LOG_PARSER_VERSION = HYADES_VERSION;

    public final static String HOST_ID_FORMAT_IPV4 = "IPV4";
    public final static String HOST_ID_FORMAT_IPV6 = "IPV6";
    public final static String FILE_PATH_KEY = "file_path";
    public final static String APACHE_VERSION_KEY = "APACHE_VERSION";
    public final static String APACHE_HTTP_SERVER = "Apache HTTP Server";
    public final static String LOCALE_EN_US = "en-US";
    public final static short SEVERITY1 = 50;
    public final static short SEVERITY2 = 30;
    public final static short SEVERITY3 = 10;

    /**
     * Constant for String "Unknown".
     */
    public final static String UNKNOWN = "Unknown";

    /**
     * Constant for String "Not Applicable".
     */
    public final static String NOT_APPLICABLE = "Not Applicable";

    /**
     * Constant for String "None".
     */
    public final static String NONE = "None";

    /**
     * Constant for String "file".
     */
    public final static String FILE = "file";

    /**
     * Constant for String "client".
     */
    public final static String CLIENT = "client";

    /**
     * Constant for String ".000000".
     */
    public final static String SIX_ZERO = ".000000";
}
