/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.common;

import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;

/**
 * @author amathur
 *
 * This is the base class for the execution event loaders and handles 
 * attributes of the base event.
 */
public abstract class XMLexecutionEventLoader extends IgnoredXMLFragmentLoader {

	// Final static debug variables
	public static final boolean DEBUG = false;		// set 'true' to turn n debugging in fragment loaders
	
	// Static variables -----------------------------
	protected final static String EVENT_ID = "id";
	protected final static String EVENT_OWNERID = "ownerId";
	protected final static String EVENT_TIMESTAMP = "timestamp";
	protected final static String EVENT_TEXT = "text";
	
	// Instance variables
	protected String 			id = null;
	protected String 			ownerId = null;
	protected long 				timestamp = -1;
	protected String 			text;
	protected TPFExecutionEvent event = null;
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
	 */
	public void initialize(HierarchyContext context, String name) {
		super.initialize(context, name);
		event = null;
		id = null;
		ownerId = null;
		timestamp = 0;
		text = null;
		
		printTag(name);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addAttribute(java.lang.String, java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		/* The attributes belonging to the base execution event are:
		 * id
		 * ownerId
		 * timestamp
		 * text
		 */
		switch (LoadersUtils.getHashCode(name)) {
			case ExecutionConstants.EVENT_ID_int :
				id = value;
				break;

			case ExecutionConstants.EVENT_OWNERID_int :
				ownerId = value;
				break;

			case ExecutionConstants.EVENT_TIMESTAMP_int :
				timestamp = Long.parseLong(value);
				break;

			case ExecutionConstants.EVENT_TEXT_int :
				text = value;
				break;

			default :
				break;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addYourselfInContext()
	 */
	public void addYourselfInContext() {
		if (event == null) {
			// Cast the specialized event to the base event before calling this method
			return;
		}
		
		printEndTag();
		
		// Set the base event attributes
		event.setId(id);
		event.setOwnerId(ownerId);
		event.setTimestamp(timestamp);
		event.setText(text);
		
		ExecutionContext eContext = (ExecutionContext) context.getCustomData().get(ExecutionContext.root);
		eContext.logEvent(event);
	}
	
	protected void printTag(String str) {
		if (DEBUG) {
			System.out.println("<" + str);
		}
	}
	
	protected void printAttribute(String name, String value) {
		if (DEBUG) {
			System.out.println(name + "=\"" + value + "\"");
		}
	}
	
	protected void printEndTag() {
		if (DEBUG) {
			System.out.println("/>");
		}
	}
}
