/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.common;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationReason;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationStatus;
import org.eclipse.hyades.models.common.testprofile.impl.Common_TestprofileFactoryImpl;

/**
 * @author amathur
 *
 * This is the invocation event loader.
 */
public class XMLinvocationEventLoader extends XMLexecutionEventLoader {
	// Static variables
	protected final static String EVENT_INVOCATION_REASON = "reason";
	protected final static String EVENT_INVOCATION_STATUS = "status";
	
	// Attribute variables
	protected TPFInvocationStatus invocationStatus = null;
	protected TPFInvocationReason invocationReason = null;

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
	 */
	public void initialize(HierarchyContext context, String name) {
		super.initialize(context, name);
		invocationStatus = null;
		invocationReason = null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addAttribute(java.lang.String, java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		printAttribute(name, value);
		switch (LoadersUtils.getHashCode(name)) {
			case ExecutionConstants.EVENT_INVOCATION_STATUS_int :
				invocationStatus = TPFInvocationStatus.get(Integer.parseInt(value));
				break;

			case ExecutionConstants.EVENT_INVOCATION_REASON_int :
				invocationReason = TPFInvocationReason.get(value);
				break;

			default :
				super.addAttribute(name, value);
				break;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addYourselfInContext()
	 */
	public void addYourselfInContext() {
		// Create the event
		TPFInvocationEvent event = Common_TestprofileFactoryImpl.eINSTANCE.createTPFInvocationEvent();
		
		// Now populate the specialized attributes
		event.setStatus(invocationStatus);
		event.setReason(invocationReason);
		
		// populate the event with the base event attributes
		this.event = (TPFExecutionEvent) event;
		super.addYourselfInContext();
	}
}
