/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.configuration;

import org.eclipse.emf.common.util.EList;

import org.eclipse.hyades.models.common.common.CMNNamedElement;

import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTimezone;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>CFG Location</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.CFGLocation#getDeployment <em>Deployment</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.CFGLocation#getTimezone <em>Timezone</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.CFGLocation#getSubLocations <em>Sub Locations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.CFGLocation#getParent <em>Parent</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.CFGLocation#getArtifacts <em>Artifacts</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGLocation()
 * @model 
 * @generated
 */
public interface CFGLocation extends CMNNamedElement{
	/**
	 * Returns the value of the '<em><b>Deployment</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.testprofile.TPFDeployment#getLocations <em>Locations</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Deployment</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Deployment</em>' container reference.
	 * @see #setDeployment(TPFDeployment)
	 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGLocation_Deployment()
	 * @see org.eclipse.hyades.models.common.testprofile.TPFDeployment#getLocations
	 * @model opposite="locations" required="true"
	 * @generated
	 */
	TPFDeployment getDeployment();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.configuration.CFGLocation#getDeployment <em>Deployment</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Deployment</em>' container reference.
	 * @see #getDeployment()
	 * @generated
	 */
	void setDeployment(TPFDeployment value);

	/**
	 * Returns the value of the '<em><b>Timezone</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.testprofile.TPFTimezone#getLocations <em>Locations</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Timezone</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Timezone</em>' reference.
	 * @see #setTimezone(TPFTimezone)
	 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGLocation_Timezone()
	 * @see org.eclipse.hyades.models.common.testprofile.TPFTimezone#getLocations
	 * @model opposite="locations"
	 * @generated
	 */
	TPFTimezone getTimezone();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.configuration.CFGLocation#getTimezone <em>Timezone</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Timezone</em>' reference.
	 * @see #getTimezone()
	 * @generated
	 */
	void setTimezone(TPFTimezone value);

	/**
	 * Returns the value of the '<em><b>Sub Locations</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.configuration.CFGLocation}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.configuration.CFGLocation#getParent <em>Parent</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Sub Locations</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Sub Locations</em>' containment reference list.
	 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGLocation_SubLocations()
	 * @see org.eclipse.hyades.models.common.configuration.CFGLocation#getParent
	 * @model type="org.eclipse.hyades.models.common.configuration.CFGLocation" opposite="parent" containment="true"
	 * @generated
	 */
	EList getSubLocations();

	/**
	 * Returns the value of the '<em><b>Parent</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.configuration.CFGLocation#getSubLocations <em>Sub Locations</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Parent</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Parent</em>' container reference.
	 * @see #setParent(CFGLocation)
	 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGLocation_Parent()
	 * @see org.eclipse.hyades.models.common.configuration.CFGLocation#getSubLocations
	 * @model opposite="subLocations"
	 * @generated
	 */
	CFGLocation getParent();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.configuration.CFGLocation#getParent <em>Parent</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Parent</em>' container reference.
	 * @see #getParent()
	 * @generated
	 */
	void setParent(CFGLocation value);

	/**
	 * Returns the value of the '<em><b>Artifacts</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.configuration.CFGArtifact}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.configuration.CFGArtifact#getLocation <em>Location</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Artifacts</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Artifacts</em>' containment reference list.
	 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage#getCFGLocation_Artifacts()
	 * @see org.eclipse.hyades.models.common.configuration.CFGArtifact#getLocation
	 * @model type="org.eclipse.hyades.models.common.configuration.CFGArtifact" opposite="location" containment="true"
	 * @generated
	 */
	EList getArtifacts();

} // CFGLocation
