/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.configuration;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.hyades.models.common.common.CommonPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory
 * @generated
 */
public interface Common_ConfigurationPackage extends EPackage{
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "configuration";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/hyades/models/common/configuration.xmi";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "Common_Configuration";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	Common_ConfigurationPackage eINSTANCE = org.eclipse.hyades.models.common.configuration.impl.Common_ConfigurationPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.configuration.impl.CFGLocationImpl <em>CFG Location</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.configuration.impl.CFGLocationImpl
	 * @see org.eclipse.hyades.models.common.configuration.impl.Common_ConfigurationPackageImpl#getCFGLocation()
	 * @generated
	 */
	int CFG_LOCATION = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_LOCATION__ID = CommonPackage.CMN_NAMED_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_LOCATION__NAME = CommonPackage.CMN_NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_LOCATION__DESCRIPTION = CommonPackage.CMN_NAMED_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Deployment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_LOCATION__DEPLOYMENT = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Timezone</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_LOCATION__TIMEZONE = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Sub Locations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_LOCATION__SUB_LOCATIONS = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_LOCATION__PARENT = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Artifacts</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_LOCATION__ARTIFACTS = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the the '<em>CFG Location</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_LOCATION_FEATURE_COUNT = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl <em>CFG Class</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl
	 * @see org.eclipse.hyades.models.common.configuration.impl.Common_ConfigurationPackageImpl#getCFGClass()
	 * @generated
	 */
	int CFG_CLASS = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_CLASS__ID = CommonPackage.CMN_NAMED_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_CLASS__NAME = CommonPackage.CMN_NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_CLASS__DESCRIPTION = CommonPackage.CMN_NAMED_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Operations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_CLASS__OPERATIONS = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Artifacts</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_CLASS__ARTIFACTS = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Instances</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_CLASS__INSTANCES = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Instantiations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_CLASS__INSTANTIATIONS = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the the '<em>CFG Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_CLASS_FEATURE_COUNT = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.configuration.impl.CFGOperationImpl <em>CFG Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.configuration.impl.CFGOperationImpl
	 * @see org.eclipse.hyades.models.common.configuration.impl.Common_ConfigurationPackageImpl#getCFGOperation()
	 * @generated
	 */
	int CFG_OPERATION = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_OPERATION__ID = CommonPackage.CMN_NAMED_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_OPERATION__NAME = CommonPackage.CMN_NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_OPERATION__DESCRIPTION = CommonPackage.CMN_NAMED_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Owning Class</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_OPERATION__OWNING_CLASS = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>CFG Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_OPERATION_FEATURE_COUNT = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.configuration.impl.CFGArtifactImpl <em>CFG Artifact</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.configuration.impl.CFGArtifactImpl
	 * @see org.eclipse.hyades.models.common.configuration.impl.Common_ConfigurationPackageImpl#getCFGArtifact()
	 * @generated
	 */
	int CFG_ARTIFACT = 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_ARTIFACT__ID = CommonPackage.CMN_NAMED_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_ARTIFACT__NAME = CommonPackage.CMN_NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_ARTIFACT__DESCRIPTION = CommonPackage.CMN_NAMED_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Deployable Instances</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_ARTIFACT__DEPLOYABLE_INSTANCES = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Deployment Spec</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_ARTIFACT__DEPLOYMENT_SPEC = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Location</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_ARTIFACT__LOCATION = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the the '<em>CFG Artifact</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_ARTIFACT_FEATURE_COUNT = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.configuration.impl.CFGDeploymentSpecImpl <em>CFG Deployment Spec</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.configuration.impl.CFGDeploymentSpecImpl
	 * @see org.eclipse.hyades.models.common.configuration.impl.Common_ConfigurationPackageImpl#getCFGDeploymentSpec()
	 * @generated
	 */
	int CFG_DEPLOYMENT_SPEC = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_DEPLOYMENT_SPEC__ID = CommonPackage.CMN_NAMED_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_DEPLOYMENT_SPEC__NAME = CommonPackage.CMN_NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_DEPLOYMENT_SPEC__DESCRIPTION = CommonPackage.CMN_NAMED_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Deployment Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_DEPLOYMENT_SPEC__DEPLOYMENT_LOCATION = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Execution Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_DEPLOYMENT_SPEC__EXECUTION_LOCATION = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Concurrency Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_DEPLOYMENT_SPEC__CONCURRENCY_MODE = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Artifact</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_DEPLOYMENT_SPEC__ARTIFACT = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Deployment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_DEPLOYMENT_SPEC__DEPLOYMENT = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the the '<em>CFG Deployment Spec</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_DEPLOYMENT_SPEC_FEATURE_COUNT = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl <em>CFG Instance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl
	 * @see org.eclipse.hyades.models.common.configuration.impl.Common_ConfigurationPackageImpl#getCFGInstance()
	 * @generated
	 */
	int CFG_INSTANCE = 5;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_INSTANCE__ID = CommonPackage.CMN_NAMED_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_INSTANCE__NAME = CommonPackage.CMN_NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_INSTANCE__DESCRIPTION = CommonPackage.CMN_NAMED_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Max Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_INSTANCE__MAX_COUNT = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Initial Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_INSTANCE__INITIAL_VALUE = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Lifeline</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_INSTANCE__LIFELINE = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Test Case</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_INSTANCE__TEST_CASE = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Class Owner</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_INSTANCE__CLASS_OWNER = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Artifact</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_INSTANCE__ARTIFACT = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Class Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_INSTANCE__CLASS_TYPE = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Environment Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_INSTANCE__ENVIRONMENT_VARIABLES = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the the '<em>CFG Instance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_INSTANCE_FEATURE_COUNT = CommonPackage.CMN_NAMED_ELEMENT_FEATURE_COUNT + 8;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.configuration.impl.CFGMachineImpl <em>CFG Machine</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.configuration.impl.CFGMachineImpl
	 * @see org.eclipse.hyades.models.common.configuration.impl.Common_ConfigurationPackageImpl#getCFGMachine()
	 * @generated
	 */
	int CFG_MACHINE = 6;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_MACHINE__ID = CFG_LOCATION__ID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_MACHINE__NAME = CFG_LOCATION__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_MACHINE__DESCRIPTION = CFG_LOCATION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Deployment</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_MACHINE__DEPLOYMENT = CFG_LOCATION__DEPLOYMENT;

	/**
	 * The feature id for the '<em><b>Timezone</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_MACHINE__TIMEZONE = CFG_LOCATION__TIMEZONE;

	/**
	 * The feature id for the '<em><b>Sub Locations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_MACHINE__SUB_LOCATIONS = CFG_LOCATION__SUB_LOCATIONS;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_MACHINE__PARENT = CFG_LOCATION__PARENT;

	/**
	 * The feature id for the '<em><b>Artifacts</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_MACHINE__ARTIFACTS = CFG_LOCATION__ARTIFACTS;

	/**
	 * The feature id for the '<em><b>Host Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_MACHINE__HOST_NAME = CFG_LOCATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>CFG Machine</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CFG_MACHINE_FEATURE_COUNT = CFG_LOCATION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.common.configuration.CFGConcurrency <em>CFG Concurrency</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.common.configuration.CFGConcurrency
	 * @see org.eclipse.hyades.models.common.configuration.impl.Common_ConfigurationPackageImpl#getCFGConcurrency()
	 * @generated
	 */
	int CFG_CONCURRENCY = 7;


	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.configuration.CFGLocation <em>CFG Location</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CFG Location</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGLocation
	 * @generated
	 */
	EClass getCFGLocation();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.common.configuration.CFGLocation#getDeployment <em>Deployment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Deployment</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGLocation#getDeployment()
	 * @see #getCFGLocation()
	 * @generated
	 */
	EReference getCFGLocation_Deployment();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.common.configuration.CFGLocation#getTimezone <em>Timezone</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Timezone</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGLocation#getTimezone()
	 * @see #getCFGLocation()
	 * @generated
	 */
	EReference getCFGLocation_Timezone();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.common.configuration.CFGLocation#getSubLocations <em>Sub Locations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Sub Locations</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGLocation#getSubLocations()
	 * @see #getCFGLocation()
	 * @generated
	 */
	EReference getCFGLocation_SubLocations();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.common.configuration.CFGLocation#getParent <em>Parent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Parent</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGLocation#getParent()
	 * @see #getCFGLocation()
	 * @generated
	 */
	EReference getCFGLocation_Parent();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.common.configuration.CFGLocation#getArtifacts <em>Artifacts</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Artifacts</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGLocation#getArtifacts()
	 * @see #getCFGLocation()
	 * @generated
	 */
	EReference getCFGLocation_Artifacts();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.configuration.CFGClass <em>CFG Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CFG Class</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGClass
	 * @generated
	 */
	EClass getCFGClass();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.common.configuration.CFGClass#getOperations <em>Operations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Operations</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGClass#getOperations()
	 * @see #getCFGClass()
	 * @generated
	 */
	EReference getCFGClass_Operations();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.common.configuration.CFGClass#getArtifacts <em>Artifacts</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Artifacts</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGClass#getArtifacts()
	 * @see #getCFGClass()
	 * @generated
	 */
	EReference getCFGClass_Artifacts();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.common.configuration.CFGClass#getInstances <em>Instances</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Instances</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGClass#getInstances()
	 * @see #getCFGClass()
	 * @generated
	 */
	EReference getCFGClass_Instances();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.common.configuration.CFGClass#getInstantiations <em>Instantiations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Instantiations</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGClass#getInstantiations()
	 * @see #getCFGClass()
	 * @generated
	 */
	EReference getCFGClass_Instantiations();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.configuration.CFGOperation <em>CFG Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CFG Operation</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGOperation
	 * @generated
	 */
	EClass getCFGOperation();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.common.configuration.CFGOperation#getOwningClass <em>Owning Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Owning Class</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGOperation#getOwningClass()
	 * @see #getCFGOperation()
	 * @generated
	 */
	EReference getCFGOperation_OwningClass();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.configuration.CFGArtifact <em>CFG Artifact</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CFG Artifact</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGArtifact
	 * @generated
	 */
	EClass getCFGArtifact();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.common.configuration.CFGArtifact#getDeployableInstances <em>Deployable Instances</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Deployable Instances</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGArtifact#getDeployableInstances()
	 * @see #getCFGArtifact()
	 * @generated
	 */
	EReference getCFGArtifact_DeployableInstances();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.common.configuration.CFGArtifact#getDeploymentSpec <em>Deployment Spec</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Deployment Spec</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGArtifact#getDeploymentSpec()
	 * @see #getCFGArtifact()
	 * @generated
	 */
	EReference getCFGArtifact_DeploymentSpec();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.common.configuration.CFGArtifact#getLocation <em>Location</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Location</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGArtifact#getLocation()
	 * @see #getCFGArtifact()
	 * @generated
	 */
	EReference getCFGArtifact_Location();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec <em>CFG Deployment Spec</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CFG Deployment Spec</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec
	 * @generated
	 */
	EClass getCFGDeploymentSpec();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec#getDeploymentLocation <em>Deployment Location</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Deployment Location</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec#getDeploymentLocation()
	 * @see #getCFGDeploymentSpec()
	 * @generated
	 */
	EAttribute getCFGDeploymentSpec_DeploymentLocation();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec#getExecutionLocation <em>Execution Location</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Execution Location</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec#getExecutionLocation()
	 * @see #getCFGDeploymentSpec()
	 * @generated
	 */
	EAttribute getCFGDeploymentSpec_ExecutionLocation();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec#getConcurrencyMode <em>Concurrency Mode</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Concurrency Mode</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec#getConcurrencyMode()
	 * @see #getCFGDeploymentSpec()
	 * @generated
	 */
	EAttribute getCFGDeploymentSpec_ConcurrencyMode();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec#getArtifact <em>Artifact</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Artifact</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec#getArtifact()
	 * @see #getCFGDeploymentSpec()
	 * @generated
	 */
	EReference getCFGDeploymentSpec_Artifact();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec#getDeployment <em>Deployment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Deployment</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec#getDeployment()
	 * @see #getCFGDeploymentSpec()
	 * @generated
	 */
	EReference getCFGDeploymentSpec_Deployment();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.configuration.CFGInstance <em>CFG Instance</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CFG Instance</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGInstance
	 * @generated
	 */
	EClass getCFGInstance();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getMaxCount <em>Max Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Max Count</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGInstance#getMaxCount()
	 * @see #getCFGInstance()
	 * @generated
	 */
	EAttribute getCFGInstance_MaxCount();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getInitialValue <em>Initial Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Initial Value</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGInstance#getInitialValue()
	 * @see #getCFGInstance()
	 * @generated
	 */
	EAttribute getCFGInstance_InitialValue();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getLifeline <em>Lifeline</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Lifeline</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGInstance#getLifeline()
	 * @see #getCFGInstance()
	 * @generated
	 */
	EReference getCFGInstance_Lifeline();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getTestCase <em>Test Case</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Test Case</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGInstance#getTestCase()
	 * @see #getCFGInstance()
	 * @generated
	 */
	EReference getCFGInstance_TestCase();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getClassOwner <em>Class Owner</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Class Owner</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGInstance#getClassOwner()
	 * @see #getCFGInstance()
	 * @generated
	 */
	EReference getCFGInstance_ClassOwner();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getArtifact <em>Artifact</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Artifact</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGInstance#getArtifact()
	 * @see #getCFGInstance()
	 * @generated
	 */
	EReference getCFGInstance_Artifact();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getClassType <em>Class Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Class Type</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGInstance#getClassType()
	 * @see #getCFGInstance()
	 * @generated
	 */
	EReference getCFGInstance_ClassType();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getEnvironmentVariables <em>Environment Variables</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Environment Variables</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGInstance#getEnvironmentVariables()
	 * @see #getCFGInstance()
	 * @generated
	 */
	EReference getCFGInstance_EnvironmentVariables();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.common.configuration.CFGMachine <em>CFG Machine</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>CFG Machine</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGMachine
	 * @generated
	 */
	EClass getCFGMachine();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.common.configuration.CFGMachine#getHostName <em>Host Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Host Name</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGMachine#getHostName()
	 * @see #getCFGMachine()
	 * @generated
	 */
	EAttribute getCFGMachine_HostName();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.models.common.configuration.CFGConcurrency <em>CFG Concurrency</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>CFG Concurrency</em>'.
	 * @see org.eclipse.hyades.models.common.configuration.CFGConcurrency
	 * @generated
	 */
	EEnum getCFGConcurrency();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	Common_ConfigurationFactory getCommon_ConfigurationFactory();

} //Common_ConfigurationPackage
