/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral;

import java.util.List;

/**
 * 
 * A test is a specification that has an implementation and that validates a 
 * system.  The test is the superclass of all test specifications such as
 * test case and test suite.  A test must have an implementor.  The implementor
 * has a flag that indicates if the test behavior is modeled.  In mapping to 
 * the Hyades test model, the implementor corresponds to the "self" lifeline for
 * for a test.
 * 
 * @author jtoomey
 * @author serge
 * @author marcelop
 * @author psun
 * @since 0.0.1
 */
public interface ITest extends INamedElement {

	/**
	 * Returns an implementor that implements the behavior of this test.
	 * There should always be an implementor. 
	 * 
	 * @return IImplemetor 
	 * 
	 */
	public IImplementor getImplementor();

	/**
	 * Returns the variables used by this test.  Implementors must enforce 
	 * that all objects in the list are instances of {@link IVariable}.
	 * 
	 * @return List 
	 * 
	 */	
	public List getVariables();
	
	/**
	 * Returns the type of the test.
	 *  
	 * @return String
	 */	
	public String getType();

	/**
	 * Sets the type of the test.
	 *  
	 * @return String
	 */		
	public void setType(String type);	
	
}
