/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.event;

import org.eclipse.hyades.test.common.util.XMLUtil;

/**
 * This is a flat class packaged in the execution environment and
 * it mirrors the 
 * {@link org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent}.
 * 
 * @author kobylin
 * @author marcelop
 */
public class VerdictEvent 
extends ExecutionEvent
{
	public static final int VERDICT_INCONCLUSIVE = 0;
	public static final int VERDICT_PASS = 1;
	public static final int VERDICT_FAIL = 2;
	public static final int VERDICT_ERROR = 3;

	public static final int REASON_UNKNOWN = 0;
	public static final int REASON_NONE = 1;
	public static final int REASON_SEE_DESCRIPTION = 2;
	public static final int REASON_ABORT = 3;
	public static final int REASON_DID_NOT_COMPLETE = 4;

	private int verdict = NOT_INITIALIZED_VALUE;
	private int reason = NOT_INITIALIZED_VALUE;
	
	/**
	 * Sets the verdict of this event.
	 * @param value
	 */
	public void setVerdict(int value)
	{
		verdict = value;
	}

	/**
	 * Returns the verdict of this event.
	 * @return int
	 */
	public int getVerdict()
	{
		return verdict;
	}


	/**
	 * Sets the reason for the status of this event.
	 * @param value
	 */
	public void setReason(int value)
	{
		reason = value;
	}

	/**
	 * Returns the reason for the status of this event.
	 * @return int
	 */
	public int getReason()
	{
		return reason;
	}
	
	/**
	 * @see org.eclipse.hyades.test.java.event.ExecutionEvent#getXMLRoot()
	 */
	protected String getXMLRoot()
	{
		return "verdictEvent";
	}

	/**
	 * @see org.eclipse.hyades.test.java.event.ExecutionEvent#addXMLAttributes(java.lang.StringBuffer)
	 */
	protected void addXMLAttributes(StringBuffer xml)
	{
		super.addXMLAttributes(xml);
		
		if(getVerdict() != NOT_INITIALIZED_VALUE)
			xml.append(XMLUtil.createXMLAttribute("verdict", Integer.toString(getVerdict()), false));
		if(getReason() != NOT_INITIALIZED_VALUE)
			xml.append(XMLUtil.createXMLAttribute("reason", Integer.toString(getReason()), false));
	}	
}
