package org.eclipse.hyades.internal.config.generator;

import com.ibm.etools.xmlschema.beans.Factory;

/**
* Provides convenience methods for creating Java beans for elements
* in this XML document
*/
public class AgentControllerConfigurationFactory extends Factory
{
  public AgentControllerConfigurationFactory()
  {
    super();
  }

  /**
  * Create the Java bean AgentControllerConfiguration for the root element
  *   @param rootElementname The tag for the root element
  *   @return AgentControllerConfiguration The Java bean representing this element
  */
  public AgentControllerConfiguration createRoot(String rootElementname)
  {
    return (AgentControllerConfiguration) createRootDOMFromComplexType("AgentControllerConfiguration",rootElementname);
  }
  
  /**
  * Create the Java bean AgentControllerConfiguration by loading the XML file
  *   @param filename The XML file name
  *   @return AgentControllerConfiguration The Java bean representing the root element
  */
  public AgentControllerConfiguration loadDocument(String filename) throws Exception
  {
    return (AgentControllerConfiguration) loadDocument("AgentControllerConfiguration",filename);
  }
  
  /**
  * Create the Java bean AgentControllerConfiguration for the element
  *   @param elementName The tag for the element
  *   @return AgentControllerConfiguration The Java bean representing this element
  */
  public AgentControllerConfiguration createAgentControllerConfiguration(String elementName)
  {
    return (AgentControllerConfiguration) createDOMElementFromComplexType("AgentControllerConfiguration",elementName);
  }
  
  /**
  * Create the Java bean Security for the element
  *   @param elementName The tag for the element
  *   @return Security The Java bean representing this element
  */
  public Security createSecurity(String elementName)
  {
    return (Security) createDOMElementFromComplexType("Security",elementName);
  }
  
  /**
  * Create the Java bean UserDefinition for the element
  *   @param elementName The tag for the element
  *   @return UserDefinition The Java bean representing this element
  */
  public UserDefinition createUserDefinition(String elementName)
  {
    return (UserDefinition) createDOMElementFromComplexType("UserDefinition",elementName);
  }
  
  /**
  * Create the Java bean GroupDefinition for the element
  *   @param elementName The tag for the element
  *   @return GroupDefinition The Java bean representing this element
  */
  public GroupDefinition createGroupDefinition(String elementName)
  {
    return (GroupDefinition) createDOMElementFromComplexType("GroupDefinition",elementName);
  }
  
  /**
  * Create the Java bean Member for the element
  *   @param elementName The tag for the element
  *   @return Member The Java bean representing this element
  */
  public Member createMember(String elementName)
  {
    return (Member) createDOMElementFromComplexType("Member",elementName);
  }
  
  /**
  * Create the Java bean Group for the element
  *   @param elementName The tag for the element
  *   @return Group The Java bean representing this element
  */
  public Group createGroup(String elementName)
  {
    return (Group) createDOMElementFromComplexType("Group",elementName);
  }
  
  /**
  * Create the Java bean AgentControllerEnvironment for the element
  *   @param elementName The tag for the element
  *   @return AgentControllerEnvironment The Java bean representing this element
  */
  public AgentControllerEnvironment createAgentControllerEnvironment(String elementName)
  {
    return (AgentControllerEnvironment) createDOMElementFromComplexType("AgentControllerEnvironment",elementName);
  }
  
  /**
  * Create the Java bean Application for the element
  *   @param elementName The tag for the element
  *   @return Application The Java bean representing this element
  */
  public Application createApplication(String elementName)
  {
    return (Application) createDOMElementFromComplexType("Application",elementName);
  }
  
  /**
  * Create the Java bean Variable for the element
  *   @param elementName The tag for the element
  *   @return Variable The Java bean representing this element
  */
  public Variable createVariable(String elementName)
  {
    return (Variable) createDOMElementFromComplexType("Variable",elementName);
  }
  
  /**
  * Create the Java bean Parameter for the element
  *   @param elementName The tag for the element
  *   @return Parameter The Java bean representing this element
  */
  public Parameter createParameter(String elementName)
  {
    return (Parameter) createDOMElementFromComplexType("Parameter",elementName);
  }
  
  /**
  * Create the Java bean Hosts for the element
  *   @param elementName The tag for the element
  *   @return Hosts The Java bean representing this element
  */
  public Hosts createHosts(String elementName)
  {
    return (Hosts) createDOMElementFromComplexType("Hosts",elementName);
  }
  
  /**
  * Create the Java bean Allow for the element
  *   @param elementName The tag for the element
  *   @return Allow The Java bean representing this element
  */
  public Allow createAllow(String elementName)
  {
    return (Allow) createDOMElementFromComplexType("Allow",elementName);
  }
  
  /**
  * Create the Java bean Deny for the element
  *   @param elementName The tag for the element
  *   @return Deny The Java bean representing this element
  */
  public Deny createDeny(String elementName)
  {
    return (Deny) createDOMElementFromComplexType("Deny",elementName);
  }
  
  /**
  * Create the Java bean Service for the element
  *   @param elementName The tag for the element
  *   @return Service The Java bean representing this element
  */
  public Service createService(String elementName)
  {
    return (Service) createDOMElementFromComplexType("Service",elementName);
  }
  
  /**
  * Create the Java bean Agent for the element
  *   @param elementName The tag for the element
  *   @return Agent The Java bean representing this element
  */
  public Agent createAgent(String elementName)
  {
    return (Agent) createDOMElementFromComplexType("Agent",elementName);
  }
  
  /**
  * Create the Java bean Option for the element
  *   @param elementName The tag for the element
  *   @return Option The Java bean representing this element
  */
  public Option createOption(String elementName)
  {
    return (Option) createDOMElementFromComplexType("Option",elementName);
  }
  
}

