package org.eclipse.hyades.trace.views.preferences.internal;

/*
 * Licensed Materials - Property of IBM
 * 5724-D14
 * (c) Copyright IBM Corporation 2002.
 * All Rights Reserved. 
 * Note to U.S. Government Users Restricted Rights:  Use, duplication or disclosure restricted by GSA ADP  schedule Contract with IBM Corp. 
 */ 

import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.*;
import org.eclipse.jface.preference.*;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
* CONTEXT_ID tcpp0000 for Console preference page
*/

/**
 * A page to set the preferences for the console
 */
public class GraphColorPreferencePage extends PreferencePage
										implements IWorkbenchPreferencePage
{
	private GraphColorUI _colorUI;
		
	/**
	 * Create the console page.
	 */
	public GraphColorPreferencePage() {
		
	}
	/**
	 * @see PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent) {

		org.eclipse.ui.help.WorkbenchHelp.setHelp(
		parent,
		TraceUIPlugin.getPluginId()+".gcpp0000");
		
		_colorUI = new GraphColorUI();
		return _colorUI.createContents(parent);
								
	}
			
	/**
	 * @see IWorkbenchPreferencePage#init
	 */
	public void init(IWorkbench workbench) {
	}
	
	/**
	 * Defaults was clicked. Restore the CVS preferences to
	 * their default values
	 */
	protected void performDefaults() {
		super.performDefaults();
		
		_colorUI.performDefaults();
	}
	
	/**
	 * OK was clicked. Store the CVS preferences.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		
		return _colorUI.performOk();
	}

	/**
	 * Returns the font data that describes the font to use for views
	 */
	public static FontData getConsoleFontData() {
		
		return GraphColorUI.getConsoleFontData();
	}
		
}
