/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.views.preferences.internal;

import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.internal.core.*;
import org.eclipse.jface.preference.*;
import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.*;

/**
 * CONTEXT_ID pfpp0000 for Profile Filters preference page.
 */

public class ProfPreferencePage {

	private TraceProfileUI _options;
	private IPreferenceStore _preferenceStore;

	public ProfPreferencePage(IPreferenceStore preferenceStore) {
		super();
		_preferenceStore = preferenceStore;
	}
	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);

		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			parent,
			UIPlugin.getPluginId() + ".pfpp0000");

		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		composite.setLayout(layout);
		
		_options = new TraceProfileUI();
		_options.createControl(composite);

		initializeValues();

		return composite;
	}
	/**
	 * Returns preference store that belongs to the our plugin.
	 * This is important because we want to store
	 * our preferences separately from the desktop.
	 *
	 * @return the preference store for this plugin
	 */
	protected IPreferenceStore doGetPreferenceStore() {
		return _preferenceStore;
	}
	public void init(IWorkbench workbench) {
	}
	/**
	 * Initializes states of the controls using default values
	 * in the preference store.
	 */
	private void initializeDefaults() {
		_options.reset();
		String filters =
			_preferenceStore.getDefaultString(TraceConstants.FILTERS_SET_KEY);
		_options.setFilterSet(filters);
	}
	/**
	 * Initializes states of the controls from the preference store.
	 */
	private void initializeValues() {
		String filters = _preferenceStore.getString(TraceConstants.FILTERS_SET_KEY);
		_options.setFilterSet(filters);
	}
	/**
	 * Does anything necessary because the default button has been pressed.
	 */
	protected void performDefaults() {
		initializeDefaults();
	}
	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		TraceProfileUI.storeValues(_options.getFilterSet());
		//PDPlugin.getDefault().savePluginPreferences();
		return true;
	}
}
