/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.hyades.trace.views.internal.*;
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;

public class StatisticTableColumnInfo {

	private boolean _isSortColumn = false;
	private boolean _isDeltaColumn = false;	
	private int _mapColumn;
	private ColumnData _columnData;
	
	public ColumnData getColumnData() {
		return _columnData;
	}
	
	public boolean isSortColumn() {
		return _isSortColumn;
	}

	public boolean isDeltaColumn() {
		return _isDeltaColumn;
	}

	public void setSortColumn(boolean flag) {
		_isSortColumn = flag;
	}

	public void setDeltaColumn(boolean flag) {
		_isDeltaColumn = flag;
	}

	static public StatisticTableColumnInfo getStatisticTableColumnInfo(TableColumn col) {
		if (col.getData() != null && col.getData() instanceof StatisticTableColumnInfo) {
			return (StatisticTableColumnInfo)(col.getData());
		}
		else {
			return null;
		}
	}


	private StatisticTableColumnInfo(StatisticView statisticView, ColumnData data) {
		TableColumn tableColumn = new TableColumn(statisticView.getTable(), SWT.NULL | SWT.NO_BACKGROUND | data.getAlignment());
		tableColumn.setData(this);
		initializeTableColumn(statisticView, tableColumn, data, true);
	}

	public StatisticTableColumnInfo(StatisticView statisticView, ColumnData data, boolean deltaColumnsEnabled) {
		TableColumn tableColumn = new TableColumn(statisticView.getTable(), SWT.NULL | SWT.NO_BACKGROUND | data.getAlignment());
		tableColumn.setData(this);
		initializeTableColumn(statisticView, tableColumn, data, false);
		
		if (deltaColumnsEnabled && data.supportsDelta()) {
			new StatisticTableColumnInfo(statisticView, data);
		}
		
	}
	
	private void initializeTableColumn(StatisticView statisticView, TableColumn tableColumn, ColumnData data, boolean isDeltaColumn) {
		Table table = statisticView.getTable();
		_columnData = data;
		_isDeltaColumn = isDeltaColumn;
		
		tableColumn.setResizable(data.isResizable());
		if (isDeltaColumn) {
			tableColumn.setText(TraceUIPlugin.getString("STR_ST_DELTA") + ":" + data.name());
		}
		else {
			tableColumn.setText(data.name());
		}
		
	    tableColumn.setWidth(data.width());
		tableColumn.addSelectionListener(statisticView);
		tableColumn.addControlListener(statisticView);
	}
}