/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.views.util.internal;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;

  
public class UpdateModel implements IRunnableWithProgress
									   , IProfileEventListener
{
    private Object selObject;
    
    /**
     * Handle UPDATE_MODEL event
     */
	public void handleProfileEvent(ProfileEvent event) {
		
		if(event.getType() == ProfileEvent.UPDATE_MODEL
		  && event.getSource() instanceof EObject)
	    {	    	
			try {
				selObject = event.getSource();
				new ProgressMonitorDialog(UIPlugin.getActiveWorkbenchShell()).run(true, true, this);
			}
			catch (InterruptedException e)
			{
				selObject = null;
			}
			catch (InvocationTargetException e)
			{
				selObject = null;
			}
			finally
			{
				selObject = null;
				
				ProfileEvent refresh_event = UIPlugin.getDefault().getRefreshViewEvent(event.getSource());
				UIPlugin.getDefault().notifyProfileEventListener(refresh_event);	            
				
			}
	    }
	}
    
	public void run(IProgressMonitor monitor)
	{
		if(selObject == null)
		  return;
		  		  
		updateDelta();  		  
		selObject = null;
	}


    private void updateDelta()
    {
		if(selObject != null)
		{
			if(selObject instanceof TRCAgentProxy)
			{
				updateDelta((TRCAgentProxy)selObject);								
				return;
			}
			
			if(selObject instanceof TRCProcessProxy)
			{
				Object[] agents = ((TRCProcessProxy)selObject).getAgentProxies().toArray();
				for(int idx=0; idx<agents.length; idx++)
				{
					updateDelta((TRCAgentProxy)agents[idx]);	
				}							
				return;
			}
			
			if(selObject instanceof TRCNode)
			{
				Object[] processes = ((TRCNode)selObject).getProcessProxies().toArray();
				for(int idx=0; idx<processes.length; idx++)
				{
					Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
					for(int i=0; i<agents.length; i++)
					{
						updateDelta((TRCAgentProxy) agents[i]);
					}					
				}
				return;								
			}
			
			if(selObject instanceof TRCMonitor)
			{
				Object[] nodes = ((TRCMonitor)selObject).getNodes().toArray();
				
				for(int k=0; k<nodes.length; k++)
				{
					Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
					for(int idx=0; idx<processes.length; idx++)
					{
						Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
						for(int i=0; i<agents.length; i++)
						{
							updateDelta((TRCAgentProxy) agents[i]);
						}
						
					}
				}
				return;								
			}
		}
    	
    }
    
	private void updateDelta(TRCAgentProxy agent)
	{
		if(!agent.getType().equals(HyadesConstants.PROFILE_AGENT_TYPE)
		   || agent.getAgent() == null || getProcess(agent.getAgent()) == null)
		  return;
		  
		TraceUtils.takeSnapshot(getProcess(agent.getAgent())); 
	}
	
    
    /**
     * 
     * @param agent
     * @return
     */
	private TRCProcess getProcess(TRCAgent agent)
	{
		if(agent.getProcess() instanceof TRCProcess)
		{
			return (TRCProcess)agent.getProcess();
		}
		
		return null;
	}

}
