/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.ui.internal.model;

/**
 * GraphFactory is used to create Graph objects. The factory itself is
 * a singleton. When a Graph is constructed, it has the type set, and the
 * loader is constructed and set based on the data model object passed in.
 */

public class GraphContentFactory implements ContentFactory
{
  private static GraphContentFactory singleton = null;
  /**
   * @since December 05, 2001
   */
  private GraphContentFactory()
  {
  }
  /**
   * @since December 05, 2001
   */
  public static ContentFactory getContentFactory()
  {
    if (singleton == null)
      singleton = new GraphContentFactory();
    return singleton;
  }

  /**
   * @since Februrary 10, 2002
   * 
   */
  public GraphNode createGraphNode()
  {
    return new ColumnNode();
  }
  /**
   * @since Februrary 10, 2002
   * 
   */
  public NodeConnection createNodeConnection()
  {
    return new NodeLink();
  }
  /**
  * @since Februrary 10, 2002
  * 
  */
  public NodeContainer createNodeContainer()
  {
    return new ColumnFigure();
  }
}
