/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.trace.sample.loganalyzer;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.analysis.engine.*;
import org.eclipse.hyades.analysis.engine.AnalysisEngineConstants;
import org.eclipse.hyades.analysis.engine.AnalysisEnginePlugin;
import org.eclipse.hyades.log.ui.internal.views.ExtensionPointHandler;
import org.eclipse.hyades.log.ui.internal.views.ExtensionPointHandler.ConfigurationElement;
import org.eclipse.hyades.log.ui.internal.views.LogContentProvider;
import org.eclipse.hyades.log.ui.internal.views.LogPage;
import org.eclipse.hyades.log.ui.internal.views.LogPaneTreeViewer;
import org.eclipse.hyades.log.ui.internal.views.LogViewer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

/**
 * @author sleeloy
 *
 * This action class will analyze an apache error log using 
 * a specific symptom database.  The corresponding viewers are 
 * also refeshed to reflect the analyzed error log file.
 */
public class AnalyzeLogAction implements IRunnableWithProgress {

	private String symptomDBPath;
	private ExtensionPointHandler eph = ExtensionPointHandler.getExtensionPointHandler();
	protected EObject mofObject;
	private LogPaneTreeViewer logPaneTreeViewer;	
	/**
	 * This method is were all the work is done.  The error log file is analyzed
	 * using a specified symptom database.  The Log Tree Viewer is also refreshed
	 * to reflect the analyzed error log file.
	 * 
	 * @see org.eclipse.jface.operation.IRunnableWithProgress#run(org.eclipse.core.runtime.IProgressMonitor)
	 * @param monitor - shows the progress of this action.
	 */
	public void run(IProgressMonitor monitor)
		throws InvocationTargetException, InterruptedException {
			//Need to set the symptom database path
			IPreferenceStore store = AnalysisEnginePlugin.getPlugin().getPreferenceStore();
			store.setValue(AnalysisEngineConstants.SYMPTOM_DB_PATH, symptomDBPath+",1");
			
			//Load symptom database
			IStructuredSelection  selection = getSelection();
			List aLogAnalyzerList = eph.getLogAnalyzers();
			ILogAnalyzer aLogAnalyzer = null;
			
			if(aLogAnalyzerList != null && aLogAnalyzerList.size() >0)
			{
				ConfigurationElement config = (ConfigurationElement) aLogAnalyzerList.get(0);
				aLogAnalyzer = config.getAnalyzer();		
				
			}
			 if(aLogAnalyzer == null)
			    return;
			        
			aLogAnalyzer.loadDatabase();
			if(aLogAnalyzer.errorMsg()==null){	
				aLogAnalyzer.analyze(selection);
			}
			logPaneTreeViewer.refresh();

			//Need to send an event so that the Analysis Result area will be updated.
			Event event = new Event();
			event.item = ((Tree) logPaneTreeViewer.getControl()).getItems()[0];
			logPaneTreeViewer.getControl().notifyListeners(SWT.Selection, event);			

	}
	
	/**
	 * This class retrieves the entire content selection from the Log Viewer.  All the contents
	 * in the log viewer will be analyzed.
	 * 
	 * @return IStructureSelection that represents the records shown in the Log Viewer.
	 */
	public IStructuredSelection getSelection(){
		//return the entire content selection
		try {
					IWorkbenchPage persp = UIPlugin.getActivePage();
					LogViewer logviewer = (LogViewer)persp.showView("org.eclipse.hyades.log.ui.internal.views.LogViewer");
					LogPage logPage = (LogPage)logviewer.getPage(mofObject);
					
					logPaneTreeViewer = logPage.getView().getViewer();
					LogContentProvider logContentProvider = (LogContentProvider)logPaneTreeViewer.getContentProvider();
					return new StructuredSelection(logContentProvider.getChildren(mofObject));
		} catch (PartInitException e) {
			e.printStackTrace();
		}
		return null;
	}


	/**
	 * Returns the symptom database location that is used to analyze the error log file.
	 * @return String that represents the symptom database location that is used to analyze the error log file.
	 */
	public String getSymptomDBPath() {
		return symptomDBPath;
	}

	/**
	 * Sets the symptom database location that is used to analyze the error log file.
	 * @param string - that represents the symptom database location that is used to analyze the error log file.
	 */
	public void setSymptomDBPath(String string) {
		symptomDBPath = string;
	}

	/**
	 * Returns the Mof object that represents the error log file.  This object will be analyzed using the 
	 * specified symptom database.
	 * @return EObject represents the error log file that will be analyzed.
	 */
	public EObject getMofObject() {
		return mofObject;
	}

	/**
	 * Sets the Mof object that represents the error log file.  This object will be analyzed using the 
	 * specified symptom database.
	 * @param object - represents the error log file that will be analyzed.
	 */
	public void setMofObject(EObject object) {
		mofObject = object;
	}

}
