/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.cbe;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

import org.eclipse.hyades.loaders.hierarchy.ForwardReference;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.loaders.util.XMLFragmentLoader;
import org.eclipse.hyades.models.cbe.CBEAssociatedEvent;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEComponentIdentification;
import org.eclipse.hyades.models.cbe.CBEDefaultElement;
import org.eclipse.hyades.models.cbe.CBEExtendedDataElement;
import org.eclipse.hyades.models.cbe.CBEFactory;
import org.eclipse.hyades.models.cbe.CBEMsgDataElement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
/**
 * @author slavescu
 *
 */
public class XMLCommonBaseEventLoader extends Stack implements XMLFragmentLoader {
    //~ Instance fields ----------------------------------------------------------------------------

    private CBECommonBaseEvent rootElement;
    private EAttribute cAtt;
    private EObject currentChild;
    private EObject newCurrentChild;
    private EObject tempObject;
    private HierarchyContext context;
    private List forwardReferences;
    private Map cdataMap;
    private StringBuffer values;

    //~ Constructors -------------------------------------------------------------------------------

    public XMLCommonBaseEventLoader() {
        super();
        cdataMap = new HashMap();
        forwardReferences = new ArrayList();
    }

    //~ Methods ------------------------------------------------------------------------------------

    public void addAttribute(String name, String value) {
        if (currentChild != null) {
            tempObject = currentChild;
        } else {
            tempObject = rootElement;
        }

        if (cAtt != null) {
            if (cAtt.getName().equals("msgCatalogTokens") && name.equals("value")) {
                EList atts = (EList) currentChild.eGet(cAtt);

                atts.add(value);
            } else {
                if (cAtt.isMany()) {
                    ((EList) tempObject.eGet(cAtt)).add(EcoreUtil.createFromString((EDataType) cAtt.getEType(), value));
                } else {
                    if (!cAtt.getName().equals("creationTime")) {
                        tempObject.eSet(cAtt, EcoreUtil.createFromString((EDataType) cAtt.getEType(), value));
                    } else {
                        setCreationTime(value);
                    }
                }
            }

            return;
        } else {
            EStructuralFeature feature;

            feature = tempObject.eClass().getEStructuralFeature(name);

            if (feature == null) {
                addUnknownAttribute(name, value);

                return;
            } else {
                if (feature instanceof EAttribute) {
                    if (!feature.getName().equals("creationTime")) {
                        Object newValue = EcoreUtil.createFromString((EDataType) feature.getEType(), value);

                        if (newValue != null) {
                            tempObject.eSet(feature, newValue);
                        }
                    } else {
                        setCreationTime(value);
                    }

                    return;
                } else if (feature instanceof EReference) {
                    addForwardReference(feature, value);

                    return;
                }
            }
        }

        addUnknownAttribute(name, value);
    }

    public void addCharacters(char[] data, int offset, int length) {
        if (currentChild == null) {
            values = (StringBuffer) cdataMap.get(rootElement);
        } else {
            values = (StringBuffer) cdataMap.get(currentChild);
        }

        if (values == null) {
            values = new StringBuffer();

            if (currentChild == null) {
                cdataMap.put(rootElement, values);
            } else {
                cdataMap.put(currentChild, values);
            }
        }

        values.append(data, offset, length);
    }

    public void addYourselfInContext() {
        if (context.getAgent() == null) {
            LoadersUtils.createAgent(context);
        }

        context.getAgent().getDefaultEvents().add(rootElement);
        processForwardReferences(context);
    }

    public void cleanUp() {
    	context=null;
    }

    public void endChild(String name) {
        if (size() > 0) {
            values = (StringBuffer) cdataMap.get(currentChild);

            if (values != null) {
                String value = values.toString().trim();

                if (value.length() > 0) {
                    if (cAtt != null) {
                        addAttribute("value", value);
                    }
                }

                cdataMap.remove(currentChild);
            }

            currentChild = (EObject) pop();
        }
    }

    public void initialize(HierarchyContext context, String name) {
        this.context = context;
        cdataMap.clear();
        forwardReferences.clear();
        cAtt = null;

        rootElement = CBEFactory.eINSTANCE.createCBECommonBaseEvent();
        rootElement.setExtensionName("CBE" + name);
        currentChild = null;
        clear();
    }

    public void startChild(String name) {
        push(currentChild);
        currentChild = createElementOrAttributeOfCurrentChild(name);
    }

    private void setCreationTime(String value) {
        rootElement.setCreationTime(LoadersUtils.convertCreationTime(value));
        rootElement.setTimeZone(LoadersUtils.getDeltaTimeZoneInMinutesFromCIMFormat(value));
    }

    private void addForwardReference(EStructuralFeature feature, String value) {
    	int index=0;
    	int prevIndex = 0;
    	index=value.indexOf(" ");
		for(;index > 0;index = value.indexOf(" ",prevIndex))
		{
			forwardReferences.add(new ForwardReference(tempObject, feature, value.substring(prevIndex,index)));
			prevIndex = index+1;
		}
		forwardReferences.add(new ForwardReference(tempObject, feature, value.substring(prevIndex)));
    }

    private void addUnknownAttribute(String name, String value) {
        CBEDefaultElement currentAttribute = CBEFactory.eINSTANCE.createCBEDefaultElement();

        currentAttribute.setName(name);
        currentAttribute.getValues().add(value);

        if (tempObject instanceof CBEExtendedDataElement || tempObject instanceof CBEDefaultElement) {
            ((CBEDefaultElement) tempObject).getChildren().add(currentAttribute);
        } else {
            rootElement.getExtendedProperties().add(currentAttribute);
        }

        return;
    }

    private EObject createElementOrAttributeOfCurrentChild(String name) {
        if (currentChild != null) {
            tempObject = currentChild;
        } else {
            tempObject = rootElement;
        }

        EStructuralFeature feature;

        if (name.equals("extendedDataElements")) {
            feature = tempObject.eClass().getEStructuralFeature("extendedProperties");
        } else {
            feature = tempObject.eClass().getEStructuralFeature(name);
        }

        if (feature == null) {
            newCurrentChild = CBEFactory.eINSTANCE.createCBEDefaultElement();
            ((CBEDefaultElement) newCurrentChild).setName(name);

            if (tempObject instanceof CBECommonBaseEvent) {
                rootElement.getExtendedProperties().add(newCurrentChild);
            }

            cAtt = null;

            //			cRef=null;
        } else {
            if (feature instanceof EAttribute) {
                newCurrentChild = tempObject;
                cAtt = (EAttribute) feature;
            } else {
                cAtt = null;
				
                if (feature.getName().equals("contextDataElements")) {
                    newCurrentChild = CBEFactory.eINSTANCE.createCBEContextDataElement();
                    rootElement.getContextDataElements().add(newCurrentChild);
                } else if (feature.getName().equals("extendedProperties")) {
                    newCurrentChild = CBEFactory.eINSTANCE.createCBEExtendedDataElement();
                    rootElement.getExtendedProperties().add(newCurrentChild);
                } else if (feature.getName().equals("msgDataElement")) {
                    newCurrentChild = CBEFactory.eINSTANCE.createCBEMsgDataElement();
                    rootElement.setMsgDataElement((CBEMsgDataElement) newCurrentChild);
                } else if (feature.getName().equals("reporterComponentId")) {
                    newCurrentChild = CBEFactory.eINSTANCE.createCBEComponentIdentification();
                    rootElement.setReporterComponentId((CBEComponentIdentification) newCurrentChild);
                } else if (feature.getName().equals("sourceComponentId")) {
                    newCurrentChild = CBEFactory.eINSTANCE.createCBEComponentIdentification();
                    rootElement.setSourceComponentId((CBEComponentIdentification) newCurrentChild);
                } else if (feature.getName().equals("associatedEvents")) {
                    newCurrentChild = CBEFactory.eINSTANCE.createCBEAssociatedEvent();
                    rootElement.getAssociatedEvents().add((CBEAssociatedEvent) newCurrentChild);
                } else if (feature.getName().equals("children")) {
                    newCurrentChild = CBEFactory.eINSTANCE.createCBEExtendedDataElement();

                    if ((currentChild != null) && (currentChild instanceof CBEExtendedDataElement || currentChild instanceof CBEDefaultElement)) {
                        ((CBEDefaultElement) currentChild).getChildren().add(newCurrentChild);
                    } else {
                        rootElement.getAssociatedEvents().add((CBEExtendedDataElement) newCurrentChild);
                    }
                }
            }
        }

        return newCurrentChild;
    }

    private void processForwardReferences(HierarchyContext context) {
        for (Iterator iter = forwardReferences.iterator(); iter.hasNext();) {
            ForwardReference ref = (ForwardReference) iter.next();
            EObject o = (EObject) LookupServiceExtensions.getInstance().locate(context, LoadersUtils.getLookUpKey(ref.getRefId()));

            if (o != null) {
                if (ref.getFeature().isMany()) {
                    ((EList) ref.getObject().eGet(ref.getFeature())).add(o);
                } else {
                    ref.getObject().eSet(ref.getFeature(), o);
                }
            } else {
                context.getGlobalForwardReferences().add(ref);
            }
        }
    }
}
