/**********************************************************************
Copyright (c) 2003 Hyades project.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Corporation - initial implementation
 IBM Rational - initial implementation
	SCAPA Technologies - initial implementation
**********************************************************************/

package org.eclipse.hyades.execution.core;

/**
 * An IExecutor class is a class that, given an IExecutableObject, is capable 
 * of launching and killing the executable represented by that IExecutableObject.
 * It is expected that IExecutionEnvironment, IExecutor and IExecutableObject
 * will be the standard specializations for executing different test types 
 * under the Hyades framework.
 * @version 0.0.2
 */
public interface IExecutor extends IExecutionComponent {
	
	/**
	 * Launches the executable on this ISession's node 
	 * 
	 * @throws ExecutionComponentStateException 
	 * 
	 */
	void launch() throws ExecutionComponentStateException;
	
	/**
	 * Kills this process if it is active.
	 */
	void kill() throws ExecutionComponentStateException;
	
	/**
	 * Set the executable object.  The executable object contains all 
	 * information necessary to execute within the parent execution environment
	 * 
	 * @param theExecutableObject An IExecutableObject instance which describes
	 * the executable in a manner understood by this IExecutor.
	 * @throws ExecutionComponentStateException If the IExecutor is not in a
	 * valid state to accept an IExecutableObject. 
	 */
	void setExecutableObject(IExecutableObject theExecutableObject) throws ExecutionComponentStateException;

	IExecutableObject getExecutableObject();

	/**
	 * Return the process console of the current executor
	 * @return IProcessConsole
	 */
	IProcessConsole getProcessConsole() throws ExecutionComponentStateException;
	
	/**
	 * Returns an empty instance of an IExecutableObject that is compatible
	 * with this IExecutor.  
	 *
	 * <p>Issue: 
	 * Do we want this to be <b>the</b> ExecutableObject (thus replacing the
	 * setExecutableObject() method), and if so, how do we know when to 
	 * pass the object across the wire (since the IExecutor doing the real work
	 * won't be the same instance of IExecutor that contains this 
	 * IExecutableObject.)</p>
	 * 	 
	 * @return an empty instance of a compatible IExecutableObject.
	 * @throws ClassNotFoundException
	 */
	IExecutableObject getCompatibleExecutableObject(String classname) throws ClassNotFoundException;
}
