/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.runner;

import java.util.HashMap;
import java.util.Map;

/**
 * Abstract class with the common attributes of an HTTP request and response.
 * 
 * @author marcelop
 * @since 1.0.2
 */
public abstract class HttpElement
{
	private String id;
	private String version;
	private Map headersByName;
	private String body;
					
	public HttpElement()
	{
		id = Integer.toString(hashCode());
	}
	
	public void addHeader(HttpHeader header)
	{
		if(HttpHeader.isValid(header))
		{
			if(headersByName == null)
				headersByName = new HashMap();
			headersByName.put(header.getName(), header);
			header.setElement(this);
		}		
	}
	
	public String getId()
	{
		return id;
	}
	
	public String getVersion()
	{
		return version;
	}
	
	public void setVersion(String version)
	{
		this.version = version;
	}

	public HttpHeader[] getHeaders()
	{
		if(headersByName == null)
			return new HttpHeader[0];
		return (HttpHeader[])headersByName.values().toArray(new HttpHeader[headersByName.values().size()]);
	}
	
	public HttpHeader getHeader(String name)
	{
		return (HttpHeader)headersByName.get(name);
	}
	
	public String getHeaderValue(String name)
	{
		HttpHeader header = getHeader(name);
		if(header == null)
			return null;
			
		return header.getValue();
	}
	
	public int getHeaderIntValue(String name)
	{
		HttpHeader header = getHeader(name);
		if(header != null)
		{
			try
			{
				return Integer.parseInt(header.getValue());
			}
			catch(NumberFormatException nfe)
			{
			}
		}
		
		return -1;
	}
	
	public void setBody(String body)
	{
		this.body = body;
	}

	public String getBody()
	{
		return body;
	}		
}
