/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.runner;


/**
 * The request is the object that stores the data that is
 * sent from the client (usually a browser) to the server.
 * 
 * @author marcelop
 * @since 1.0.2
 */ 
public class HttpRequest
extends HttpElement
{
	private String method;
	private String host;
	private int port;
	private String absolutePath;
	
	private HttpResponse response;
	
	public String getURL()
	{
		if(getHost() == null)
			return null;
			
		StringBuffer url = new StringBuffer("http://").append(getHost());
		
		if(getPort() > 0)
			url.append(":").append(getPort());
			
		if(getAbsolutePath() != null)
			url.append(getAbsolutePath());
			
		return url.toString();
	}

	/**
	 * @return
	 */
	public String getAbsolutePath()
	{
		return absolutePath;
	}

	/**
	 * @param absolutePath
	 */
	public void setAbsolutePath(String absolutePath)
	{
		this.absolutePath = absolutePath;
	}

	/**
	 * @return
	 */
	public String getHost()
	{
		return host;
	}

	/**
	 * @param host
	 */
	public void setHost(String host)
	{
		this.host = host;
	}

	/**
	 * @return
	 */
	public String getMethod()
	{
		return method;
	}

	/**
	 * @param method
	 */
	public void setMethod(String method)
	{
		this.method = method;
	}

	/**
	 * @return
	 */
	public int getPort()
	{
		return port;
	}

	/**
	 * @param port
	 */
	public void setPort(int port)
	{
		this.port = port;
	}
		
	public HttpResponse getResponse()
	{
		return response;
	}

	/**
	 * All the verification to enforce the bidirectional association
	 * must be done by the caller of this method
	 */
	void setResponse(HttpResponse response)
	{
		this.response = response;
	}
}
