/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

/**
 * A list of adaptable objects.  This is a generic list that can
 * be used to display an arbitrary set of adaptable objects in the workbench.
 * Also implements the IWorkbenchAdapter interface for simple display
 * and navigation.
 */
public class AdaptableList implements IWorkbenchAdapter,  IAdaptable {
	protected List children = null;
/**
 * Creates a new adaptable list.
 */
public AdaptableList() {
	children = new ArrayList();
}
/**
 * Creates a new adaptable list with the given size.
 */
public AdaptableList(int size) {
	children = new ArrayList(size);
}
/**
 * Creates a new adaptable list with the given children.
 */
public AdaptableList(IAdaptable[] newChildren) {
	this(newChildren.length);
	for (int i = 0; i < newChildren.length; i++) {
		children.add(newChildren[i]);
	}
}
/**
 * Adds all the adaptable objects in the given enumeration to this list.
 * Returns this list.
 */
public AdaptableList add(Iterator e) {
	while (e.hasNext()) {
		add((IAdaptable)e.next());
	}
	return this;
}
/**
 * Adds the given adaptable object to this list.  Returns this list.
 */
public AdaptableList add(IAdaptable a) {
	children.add(a);
	return this;
}
/**
 * Returns an object which is an instance of the given class
 * associated with this object. Returns <code>null</code> if
 * no such object can be found.
 */
public Object getAdapter(Class adapter) {
	if (adapter == IWorkbenchAdapter.class) return this;
	return null;
}
/**
 * Returns the elements in this list.
 */
public Object[] getChildren() {
	return children.toArray();
}
/**
 * Returns the elements in this list.
 * @see IWorkbenchAdapter#getChildren
 */
public Object[] getChildren(Object o) {
	return children.toArray();
}
/**
 * Adds the given adaptable object to this list.
 */
public void remove(IAdaptable a) {
	children.remove(a);
}
/**
 * Returns the number of items in the list
 */
public int size() {
	return children.size();
}
/**
 * For debugging purposes only.
 */
public String toString() {
	return children.toString();
}
/**
 * A convenience method for getting the label of an adaptable
 * object that responds to the IWorkbenchAdapter adapter interface.
 * Returns a toString() of the object if it is not adaptable
 */
public static String getElementLabel(IAdaptable a) {
	if (a == null) {
		return "";//$NON-NLS-1$
	}
	IWorkbenchAdapter adapter = (IWorkbenchAdapter)a.getAdapter(IWorkbenchAdapter.class);
	if (adapter != null) {
		return adapter.getLabel(a);
	} else {
		return a.toString();
	}
}
/**
 * @see IWorkbenchAdapter#getImageDescriptor
 */
public ImageDescriptor getImageDescriptor(Object object) {
	return null;
}
/**
 * @see IWorkbenchAdapter#getLabel
 */
public String getLabel(Object o) {
	return o == null ? "" : o.toString();//$NON-NLS-1$
}
/**
 * @see IWorkbenchAdapter#getParent
 */
public Object getParent(Object o) {
	return null;
}

}
