/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.wizards;

import java.net.*;

import org.eclipse.core.runtime.*;
import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.jface.dialogs.*;
import org.eclipse.jface.resource.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.jface.wizard.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.*;
import org.eclipse.ui.help.*;
import org.eclipse.ui.plugin.*;

/**
 * 
 */
public class ImportLogSelectionWizard extends Wizard implements INewWizard {
	private IWorkbench workbench;
	private IStructuredSelection selection;
	
    public ImportLogSelectionWizard() {

        AbstractUIPlugin plugin = (AbstractUIPlugin) Platform.getPlugin(PlatformUI.PLUGIN_ID);

        IDialogSettings workbenchSettings = plugin.getDialogSettings();

        IDialogSettings section = workbenchSettings.getSection("org.eclipse.hyades.log.ui.internal.internal.wizards.ImportLogSelectionWizard");

        if (section == null)
            section = workbenchSettings.addNewSection("org.eclipse.hyades.log.ui.internal.internal.wizards.ImportLogSelectionWizard");

        setDialogSettings(section);
    }

	

	//the list selection page
	class SelectionPage extends WorkbenchWizardListSelectionPage {
		SelectionPage(IWorkbench w, IStructuredSelection ss, AdaptableList e, String s) {
			super(w, ss, e, s);
		}
		public void createControl(Composite parent) {
			super.createControl(parent);
			WorkbenchHelp.setHelp(getControl(), LogUIPlugin.getPluginId() + ".pp0000");
			setTitle(LogUIPlugin.getResourceString("LOG_PARSER_PAGE_TITLE"));
			setDescription(LogUIPlugin.getResourceString("LOG_PARSER_PAGE_DESC"));
		}
		public IWizardNode createWizardNode(LogWizardElementBase element) {
			ImportWizardNode wizardNode = new ImportWizardNode(element.getParserId(), this);
			return wizardNode;
		}
	}
	

	/**
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish() {
		((SelectionPage)getPages()[0]).saveWidgetValues();
		return true;
	}

	/**
	 * @see org.eclipse.ui.IWorkbenchWizard#init(IWorkbench, IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.workbench = workbench;
		this.selection = selection;
	
		setWindowTitle(LogUIPlugin.getResourceString("IMPORT_LOG_FILE_WIZARD_TITLE")); //$NON-NLS-1$
		setDefaultPageImageDescriptor(LogUIPluginImages.getImageDescriptor(LogUIPluginImages.IMG_IMPORT_WIZ_BAN));
		setNeedsProgressMonitor(true);
		
	}

	/**
	 * Returns the import wizards that are available for invocation.
	 */
	protected AdaptableList getAvailableImportWizards() {
		//read the plugin.xml to get the list of imports.
		IPluginRegistry reg = Platform.getPluginRegistry();
	
		IConfigurationElement[] config =
			reg.getConfigurationElementsFor("org.eclipse.hyades.logging.parsers", "logParser");
			
		AdaptableList list = new AdaptableList();
	
		for (int idx = 0; idx < config.length; idx++) {
			IConfigurationElement elem = config[idx];
						
			LogWizardElementBase parser = new LogWizardElementBase(elem.getAttribute("name"));
			
			
			parser.setDescription(elem.getAttribute("description"));
			parser.setParserConfigurationElement(elem);
			parser.setParserId(elem.getAttribute("id"));
					
			String iconPath = elem.getAttribute("icon");
			if(iconPath != null && !iconPath.equals(""))
			{
				URL pluginURL = elem.getDeclaringExtension().getDeclaringPluginDescriptor().getInstallURL();
				try {
					URL url = new URL(pluginURL, iconPath);
					ImageDescriptor image = ImageDescriptor.createFromURL(url);
					parser.setImageDescriptor(image);
				}
				catch(Exception exc)
				{
					// if the URL does not have a valid format, just log and ignore the exception
					IStatus status = new Status(IStatus.ERROR, LogUIPlugin.getPluginId(), 2,"exception.malformedURL", exc); //$NON-NLS-1$
					LogUIPlugin.getDefault().getLog().log(status);
					continue;
					
				}
				
			}
			list.add(parser);
														 			
		}
		return list;
		
	}
	

	/**
	 * Creates the wizard's pages lazily.
	 */
	public void addPages() {
		addPage(
			new SelectionPage(
				this.workbench, 
				this.selection, 
				getAvailableImportWizards(), 
				LogUIPlugin.getResourceString("LOG_PARSER_PAGE_DESC")));  //$NON-NLS-1$
	}

}
