/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.wizards;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.jface.preference.*;
import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

/**
 * 
 */
public class ImportWizardCheckBox implements IImportWizardWidget,Listener {
	
	protected Button checkBox;

	/**
	 * @see com.ibm.etools.pd.ras.wizard.IImportWizardWidget#getValue()
	 */
	public String getValue() {
		return (checkBox.getSelection() ? "true": "false");
	}

	/**
	 * @see com.ibm.etools.pd.ras.wizard.IImportWizardWidget#createControl(Composite, ParserField, String)
	 */
	public void createControl(
		Composite composite,
		ParserField field,
		String prefix) {
        Label label = new Label(composite, SWT.NULL | SWT.WRAP);            
        GridData data = new GridData();
        data.widthHint = 400;
        data.horizontalSpan = 2;            
        label.setLayoutData(data);
        label.setText(field.getName());
        
		checkBox = new Button(composite, SWT.CHECK | SWT.LEFT);
		checkBox.setToolTipText(field.getTooltip());

        checkBox.addListener(SWT.Selection, this);
        
        
        boolean defaultValue = true;
        
        IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
            
        String previousValue = store.getString(prefix + field.getId());
        
        if (previousValue != null && previousValue.trim().equalsIgnoreCase("false"))
        	defaultValue = false;
        
        checkBox.setSelection(defaultValue);
        
	}

	/**
	 * Returns the checkBox.
	 * @return Button
	 */
	public Button getCheckBox() {
		return checkBox;
	}

	/**
	 * Sets the checkBox.
	 * @param checkBox The checkBox to set
	 */
	public void setCheckBox(Button checkBox) {
		this.checkBox = checkBox;
	}


	/**
	 * @see org.eclipse.swt.widgets.Listener#handleEvent(Event)
	 */
	public void handleEvent(Event event) {
	}

	/**
	 * @see com.ibm.etools.pd.ras.wizard.IImportWizardWidget#isValid()
	 */
	public boolean isValid() {
		return true;
	}

}
