/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.StringTokenizer;

import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

/**
 * 
 */
public class ImportWizardComboBox implements IImportWizardWidget {

	protected Combo comboBox;
	/**
	 * @see com.ibm.etools.pd.ras.wizard.IImportWizardWidget#getValue()
	 */
	public String getValue() {
		return comboBox.getItem(comboBox.getSelectionIndex());
	}

	/**
	 * @see com.ibm.etools.pd.ras.wizard.IImportWizardWidget#createControl(Composite, ParserField)
	 */
	public void createControl(Composite composite, ParserField field, String prefix) {
		Label label = new Label(composite, SWT.NULL | SWT.WRAP);
		GridData data = new GridData();
		data.widthHint = 400;
		data.horizontalSpan = 2;
		label.setLayoutData(data);
		label.setText(field.getName());

		comboBox = new Combo(composite, SWT.BORDER|SWT.READ_ONLY);
		comboBox.setToolTipText(field.getTooltip());
		comboBox.setLayoutData(GridUtil.createFill());
		comboBox.setLayout(new GridLayout());
		
		// Get the previous value from the preference store, if one exists.
		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();

		String previousValue = store.getString(prefix + field.getId());

		//parse previousValue.  This value should be a list of comma separated values
		StringTokenizer st = new StringTokenizer(field.getDefaultValue(), ",");
		int selIndex = 0;
		int index = 0;
		while (st.hasMoreTokens()) {
			String token = st.nextToken();
			comboBox.add(token);
			if ((previousValue != null)
				&& (previousValue.trim().equals(token)))
				selIndex = index;
			index++;
		}

		comboBox.select(selIndex);

	}

	/**
	 * Returns the comboBox.
	 * @return Combo
	 */
	public Combo getComboBox() {
		return comboBox;
	}

	/**
	 * Sets the comboBox.
	 * @param comboBox The comboBox to set
	 */
	public void setComboBox(Combo comboBox) {
		this.comboBox = comboBox;
	}

	/**
	 * @see com.ibm.etools.pd.ras.wizard.IImportWizardWidget#isValid()
	 */
	public boolean isValid() {
		return true;
	}

}
