/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.wizards;


public class ParserField
{
	protected String _id="";
	protected String _name="";
	protected String _defaultValue="";
	protected boolean _useBrowse;
	protected String _browseFilters="*"; 
	protected String _tooltip="";
	protected String _contextId="";
	protected String uiType ="text_field";
	
	public ParserField(String id, String name)
	{
		if(id != null)
			_id = id;
		if(name != null)	
			_name = name;
	}
	
	public void setDefaultValue(String val)
	{
		if(val != null)
			_defaultValue = val;
	}
	
	public void useBrowse(boolean useBrowse)
	{
		_useBrowse = useBrowse;
	}
	
	public void setFilters(String filters)
	{		
		_browseFilters = filters;
	}
	
	public void setTooltip(String tooltip)
	{
		if(tooltip != null)
			_tooltip = tooltip;
	}
	
	public void setContextId(String contextId)
	{
		if(contextId != null)
			_contextId = contextId;
	}
	
	public String getDefaultValue()
	{
		return _defaultValue;
	}
	
	public String getId()
	{
		return _id;
	}
	
	public String getName()
	{
		return _name;
	}
	
	public String getContextId()
	{
		return _contextId;
	}
	
	public String getTooltip()
	{
		return _tooltip;
	}
	
	public boolean useBrowse()
	{
		return _useBrowse;
	}
	
	public String getFilters()
	{
		return _browseFilters;
	}
	/**
	 * Returns the uiType.
	 * @return String
	 */
	public String getUiType() {
		return uiType;
	}

	/**
	 * Sets the uiType.
	 * @param uiType The uiType to set
	 */
	public void setUiType(String uiType) {
		if (uiType != null)
			this.uiType = uiType;
	}

}
