/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal;

import java.util.*;

import org.eclipse.core.runtime.*;
import org.eclipse.emf.ecore.resource.*;
import org.eclipse.hyades.models.internal.sdb.impl.*;
import org.eclipse.hyades.sdb.internal.util.*;
import org.eclipse.jface.preference.*;
import org.eclipse.jface.resource.*;
import org.eclipse.ui.plugin.*;

public class SDbPlugin extends AbstractUIPlugin
{
	private static SDbPlugin inst;
	private static ResourceBundle fResourceBundle;
	private SDBFactoryImpl factory;
	private ResourceSet resourceSet;

	public SDbPlugin(IPluginDescriptor descriptor) {
		super(descriptor);

		if (inst == null)
			inst = this;

		try {
			fResourceBundle = getDescriptor().getResourceBundle();
		}
		catch (MissingResourceException x) {
			x.printStackTrace();
		}
		
	}
	public static SDbPlugin getDefault() {
		return inst;
	}

	public static String getPluginId() {
		return getDefault().getDescriptor().getUniqueIdentifier();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (2/16/2001 4:57:29 PM)
	 * @return com.ibm.jface.resource.ImageDescriptor
	 * @param name java.lang.String
	 */
	public static ImageDescriptor getImageDescriptor(String name) {
		return SDbPluginImages.getImageDescriptor(name);
	}
	public static ResourceBundle getResourceBundle() {
		return fResourceBundle;
	}
	public static String getResourceString(String key) {
		ResourceBundle bundle = SDbPlugin.getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}
	public void shutdown() throws CoreException {
		SDbPluginImages.shutdown();

		super.shutdown();
	}
	public void startup() throws CoreException {
		SDBPackageImpl.init();

		factory = new SDBFactoryImpl();

		// init resourceSet
		resourceSet = SDBResourceSetImpl.getInstance();

		super.startup();
	}

	public SDBFactoryImpl getSDBFactory() {
		if (factory == null)
			factory = new SDBFactoryImpl();
		return factory;
	}

	/*
	 * 
	 */
	public ResourceSet getResourceSet() {
		return resourceSet;
	}

	/**
	 * Sets default preference values. These values will be used
	 * until some preferences are actually set using Preference dialog.
	 */
	protected void initializeDefaultPreferences(IPreferenceStore store) {
		
		String url =
			getResourceString("STR_StdURL_NAME")
				+ "\t"
				+ SdUIConstants.StdURL
				+ "\n"
				+ getResourceString("STR_AdvURL_NAME")
				+ "\t"
				+ SdUIConstants.AdvURL;

		store.setDefault(SdUIConstants.SYMPTOM_DB_URL, url);
	}

}
