/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.wizard;

import java.io.*;
import java.util.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.emf.common.util.*;
import org.eclipse.emf.ecore.resource.*;
import org.eclipse.hyades.models.internal.sdb.*;
import org.eclipse.hyades.models.internal.sdb.impl.*;
import org.eclipse.hyades.sdb.internal.*;
import org.eclipse.hyades.sdb.internal.help.*;
import org.eclipse.hyades.sdb.internal.util.*;
import org.eclipse.jface.dialogs.*;
import org.eclipse.jface.operation.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.dialogs.*;
import org.eclipse.ui.help.*;

public class ExportSymptomDBWizardPage
	extends WizardDataTransferPage
	implements Listener, ModifyListener, IRunnableWithProgress {

	private Text txtSourceFileName;
	private Text txtTargetFileName;
	private Button btnSourceBrowse;
	private Button btnTargetBrowse;
	private Button btnOldVersion;
	private Button btnNewVersion;
	private Button btnOverwriteCheckbox;
	private Button btnCreateFolderCheckbox;
	private SDBRuntime root = null;
	private boolean exception = false;
	private File output = null;
	private Writer writer = null;
	private String lastTargetFolder = "";
	private boolean v5 = true;
	private String extension = "trcdbxmi";
	private String sourceName = "";

	protected ExportSymptomDBWizardPage(String pageName) {
		super(pageName);
		setTitle(SDbPlugin.getResourceString("STR_EXPORT_SYMPTOM_DB_PTITLE"));
		setDescription(SDbPlugin.getResourceString("STR_EXPORT_SYMPTOM_DB_PDESC"));
		setImageDescriptor(
			SDbPluginImages.getImageDescriptor(SDbPluginImages.IMG_EXPORT_DB_WIZ_BAN));
		
	}
	/**
	 *  Handle all events and enablements for widgets in this dialog
	 *
	 * @param event Event
	 */
	public void handleEvent(Event event) {
		setErrorMessage(null);
		if (event.widget == btnTargetBrowse)
			showTargetDialog();
		if(event.widget == btnSourceBrowse){
			showFileDialog();
		}

	}
	protected boolean allowNewContainerName() {
		return true;
	}
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout());
		GridData data = GridUtil.createFill();
		data.widthHint = 300;
		composite.setLayoutData(data);
		composite.setLayoutData(data);

		Composite sourceGrp = new Composite(composite, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		layout.verticalSpacing = 10;
		layout.horizontalSpacing = 4;
		data = GridUtil.createHorizontalFill();
		data.widthHint = 300;
		sourceGrp.setLayout(layout);
		sourceGrp.setLayoutData(data);
		
		Label sourceLabel = new Label(sourceGrp, SWT.NONE);
		data = new GridData();
		data.horizontalSpan = 2;
		sourceLabel.setLayoutData(data);
		sourceLabel.setText(SDbPlugin.getResourceString("STR_SYMPTOM_DB_SOURCE"));

		// source name entry field
		txtSourceFileName = new Text(sourceGrp, SWT.BORDER);
		data = GridUtil.createHorizontalFill();
		//data.grabExcessHorizontalSpace = true;
		txtSourceFileName.setLayoutData(data);

		// source file browse button
		btnSourceBrowse = new Button(sourceGrp, SWT.PUSH);
		btnSourceBrowse.setText(SDbPlugin.getResourceString("STR_IMPORT_LOG_FILE_BROWSE1"));


		Composite targetGrp = new Composite(composite, SWT.NONE);
		layout = new GridLayout();
		layout.numColumns = 3;
		layout.verticalSpacing = 10;
		layout.horizontalSpacing = 4;
		data = GridUtil.createHorizontalFill();
		data.widthHint = 300;
		targetGrp.setLayout(layout);
		targetGrp.setLayoutData(data);

		Label locationLabel = new Label(targetGrp, SWT.NONE);
		data = new GridData();
		data.horizontalSpan = 3;
		//data.horizontalIndent = 10;
		locationLabel.setLayoutData(data);
		locationLabel.setText(SDbPlugin.getResourceString("STR_EXPORT_DESTINATION"));

		Label targetLabel = new Label(targetGrp, SWT.NONE);
		data = new GridData();
		targetLabel.setLayoutData(data);
		targetLabel.setText(SDbPlugin.getResourceString("STR_EXPORT_DEST_LABEL"));
		
		// target name entry field		
		txtTargetFileName = new Text(targetGrp, SWT.BORDER);
		txtTargetFileName.setLayoutData(GridUtil.createHorizontalFill());

		// target folder browse button
		btnTargetBrowse = new Button(targetGrp, SWT.PUSH);
		btnTargetBrowse.setText(SDbPlugin.getResourceString("STR_IMPORT_XMLLOG_BROWSE"));

		createSpacer(composite);
		createVersionGroup(composite);
		createSpacer(composite);
		createPlainLabel(
			composite,
			SDbPlugin.getResourceString("ExportDBWizardPage.options"));

		createOptionsGroup(composite);
		initControls();
		setControl(composite);

		btnSourceBrowse.addListener(SWT.Selection, this);
		btnTargetBrowse.addListener(SWT.Selection, this);
		txtTargetFileName.addModifyListener(this);
		txtSourceFileName.addModifyListener(this);

		WorkbenchHelp.setHelp(txtSourceFileName, ContextIds.EXPORT_SYMDB_RESOURCE);
		WorkbenchHelp.setHelp(txtTargetFileName, ContextIds.EXPORT_SYMDB_DESTINATION);
		setPageComplete(determinePageCompletion());
	}
	protected void createVersionGroup(Composite parent) {
		Group versionGrp = new Group(parent, SWT.NONE);
		versionGrp.setText(SDbPlugin.getResourceString("STR_EXPORT_TO_VERSION"));
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		GridData data = new GridData();
		data.horizontalIndent = 15;
		data.widthHint = SWT.DEFAULT;
		versionGrp.setLayout(layout);
		versionGrp.setLayoutData(data);

		btnNewVersion = new Button(versionGrp, SWT.RADIO);
		btnNewVersion.setText(SDbPlugin.getResourceString("STR_EXPORT_NEW_VERSION"));
		btnNewVersion.setLayoutData(GridUtil.createHorizontalFill());

		btnOldVersion = new Button(versionGrp, SWT.RADIO);
		btnOldVersion.setText(SDbPlugin.getResourceString("STR_EXPORT_OLD_VERSION"));
		btnOldVersion.setLayoutData(GridUtil.createHorizontalFill());

		WorkbenchHelp.setHelp(versionGrp, ContextIds.EXPORT_SYMDB_XML_FORMAT);
	}
	protected void createOptionsGroup(Composite parent) {
		Composite optionsGroup = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.marginHeight = 0;
		optionsGroup.setLayout(layout);
		optionsGroup.setLayoutData(GridUtil.createHorizontalFill());

		btnOverwriteCheckbox= new Button(optionsGroup, SWT.CHECK | SWT.LEFT);
		btnOverwriteCheckbox.setText(SDbPlugin.getResourceString("ExportDBWizardPage.override.text")); 
		btnOverwriteCheckbox.addListener(SWT.Selection, this);
		
		WorkbenchHelp.setHelp(btnOverwriteCheckbox, ContextIds.EXPORT_SYMDB_OVERWRITE_FILE);

	}
	public void modifyText(ModifyEvent e) {
		setErrorMessage(null);
		setPageComplete(determinePageCompletion());
	}

	private void showFileDialog() {
		
		String fName = "";
		SymptomDBSelectionDialog dialog =
			new SymptomDBSelectionDialog(
				getShell(),
				SDbPlugin.getResourceString("STR_RES_DLG_MSG"));

		if (dialog.open() == SymptomDBSelectionDialog.OK) {

			Object[] result = dialog.getResult();
			if (result != null && result.length == 1 && result[0] != null) {
				IPath path = (IPath) result[0];
				fName = path.toOSString();
				sourceName = path.toString();
			}
		}
				
		if (fName != null && !fName.equals("")) {
			txtSourceFileName.setText(fName);
		}
		setPageComplete(determinePageCompletion());
	}

	private void showTargetDialog() {
		String currentSource = txtSourceFileName.getText();

		currentSource = getTargetFileNameFromSourceName(currentSource);
		FileDialog dlg = new FileDialog(getShell(), SWT.SAVE);
		
		if(lastTargetFolder.length()>0){
			dlg.setFilterPath(lastTargetFolder);			
		}
		dlg.setFileName(currentSource);
		dlg.setFilterExtensions(new String[]{"*.xml", "*.*"});
		
		String target = dlg.open();

		if(target!=null){
			txtTargetFileName.setText(target);
			lastTargetFolder = getDirectoryName(target);
		}
			
		setPageComplete(determinePageCompletion());			
	}

	private String getTargetFileNameFromSourceName(String source){

		int i = source.indexOf("trcdbxmi");
		if(i>-1)
			source = source.substring(0, i) + "xml";
		i = source.lastIndexOf(File.separatorChar);
		if(i>-1)
			source = source.substring(i+1);

		return source;
	
	}
	
	public void run(IProgressMonitor monitor) {
		try {
			String message = SDbPlugin.getResourceString("STR_EXPORT_GEN_XML_MSG");
			message = TString.change(message, "%1", output.getName());

			monitor.beginTask(message, 10000);

			if (root == null)
				loadModel(monitor);

			if (v5) {
				SymptomDBExportUtil generator = new SymptomDBExportUtil();
				writer.write(generator.generate(root, monitor));
			} else {
				SymptomDBExportToV4Util generator = new SymptomDBExportToV4Util();
				writer.write(generator.generate(root, monitor));
			}

			writer.flush();
			writer.close();
//opensrc			
//			((ReferencedXMIResourceImpl)root.refResource()).releaseFromRead();

		} catch (Exception e) {
			e.printStackTrace();
			monitor.done();
			exception = true;
		}
		monitor.done();
	}
	protected boolean determinePageCompletion() {
		boolean complete = validateSourceGroup() && validateDestinationGroup() ;

		// Avoid draw flicker by not clearing the error
		// message unless all is valid.
		if (complete)
			setErrorMessage(null);

		return complete;
	}
	
	protected boolean validateSourceGroup(){
		String source = txtSourceFileName.getText().trim();

		if(source.equals(""))
			return false;
		
		if(!source.startsWith(new String(new char[]{File.separatorChar}))){
			source = File.separatorChar + source;
		}
			
		boolean result = resourceExists(source);
		if(!result)
			setErrorMessage(SDbPlugin.getResourceString("STR_INVALID_SOURCE_MSG"));
		return result;
	}
	
	protected boolean validateDestinationGroup() {
		return !txtTargetFileName.getText().trim().equals("");
	}
	protected boolean performFinish() {
		String fName = txtTargetFileName.getText();

		String dirName = getDirectoryName(fName);
		exception = false;
		if (!targetFolderExists(new File(dirName)))
			return false;

		output = new File(fName);
		if (output.exists()) {
			if(!btnOverwriteCheckbox.getSelection()){
				String result = queryOverwrite(fName);
				if (result.equals("NO") || result.equals("NOALL") || result.equals("CANCEL") ) {
	
					return false;
				}
			}
		}

		try {
//			writer = new FileWriter(output);
			OutputStream outStream = new FileOutputStream(output.toString(), false);
			writer = new OutputStreamWriter(outStream, "UTF-8");
		} catch (IOException e) {
			String errMsg = SDbPlugin.getResourceString("STR_CREATE_FILE_ERROR_");
			MessageDialog.openError(
				getContainer().getShell(),
				SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"),
				errMsg);
			return false;
		}

		v5 = btnNewVersion.getSelection();
		try {
			getWizard().getContainer().run(true, true, this);
		} catch (Exception e) {

			e.printStackTrace();
			exception = true;
		}

		if (exception) {
			//Status error = new Status(Status.WARNING, ResourcesPlugin.PI_RESOURCES, IResourceStatus.INTERNAL_ERROR, e.toString(), e);

			String errMsg = SDbPlugin.getResourceString("STR_EXPORT_SYMPTOMDB_ERROR_");

			MessageDialog.openError(
				getContainer().getShell(),
				SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"),
				errMsg);

			return false;
		}
		return true;
	}
	private boolean targetFolderExists(File directory) {
		if (!directory.exists()) {

			if (!queryYesNoQuestion(SDbPlugin
				.getResourceString("STR_FOLDER_CREATION_MSG")))
				return false;

			if (!directory.mkdirs()) {

				String errMsg = SDbPlugin.getResourceString("STR_FOLDER_CREATION_ERROR_");

				MessageDialog.openError(
					getContainer().getShell(),
					SDbPlugin.getResourceString("SYMPTOMDB_MESSAGE"),
					errMsg);
				return false;
			}
		}
		return true;
	}
	private void initControls() {
		IFile iFile = ((ExportSymptomDBWizard) getWizard()).getFile();
		if(iFile!=null){			
			String fName = iFile.getFullPath().toOSString();
			sourceName = iFile.getFullPath().toString();
			txtSourceFileName.setText(fName);
		}
		btnNewVersion.setSelection(true);
	}
	private void loadModel(IProgressMonitor monitor)
		throws Exception {
		try {

			ResourceSet resourceSet = new SDBResourceSetImpl();
			Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("trcdbxmi", new SDBResourceFactoryImpl());
			
			monitor.worked(500);
			Resource res = resourceSet.getResource(URI.createURI("platform:/resource" +  sourceName), true);
			
			monitor.worked(1000);
			Iterator i = res.getContents().iterator();
			while (i.hasNext()) {
				Object obj = i.next();
				if (obj instanceof SDBRuntime) {
					root = (SDBRuntime) obj;
					monitor.worked(500);
					return;
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
	}
	
	private String getDirectoryName(String fName){
		int i = fName.lastIndexOf(File.separatorChar);
		if(i>=0){
			fName = fName.substring(0,i);
		}
		return fName;
	}
	
	private boolean resourceExists(String fName){
		IStatus result = ResourcesPlugin.getWorkspace().validatePath(fName, IResource.FILE);
		if(result.getSeverity()!=IStatus.OK){			
			return false;
		}
		IPath path = new Path(fName);
		IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
		if(file!=null && file.exists())
			return true;

		return false;	
	}
	
}
