/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.wizard;

import java.io.File;
//import java.util.HashMap;
import java.util.*;
import java.util.Map;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.help.WorkbenchHelp;

import org.eclipse.hyades.analysis.engine.AnalysisEngineConstants;
import org.eclipse.hyades.analysis.engine.AnalysisEnginePlugin;
import org.eclipse.hyades.models.internal.sdb.*;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.TString;
import org.eclipse.jface.preference.IPreferenceStore;

public class NewSymptomDBWizardPage extends WizardDataTransferPage implements Listener {

	private Text txtLocationFolder;
	private Text txtDBName;
	private Text txtDescription;
	private Button btnLocationBrowse;
    private Button btnCreateFolderCheckbox;
	private String selFolder;
    private static final String DB_EXT = ".trcdbxmi";    

	/**
	 * Constructor for NewSymptomDBWizardPage.
	 * @param pageName
	 * @param title
	 * @param titleImage
	 */
	protected NewSymptomDBWizardPage(String pageName) {
		super(pageName);
	  	setTitle(SDbPlugin.getResourceString("STR_SYPMTOMDB_NEW_WIZARD_PTITLE"));	
        setDescription(SDbPlugin.getResourceString("STR_SYPMTOMDB_NEW_WIZARD_PDESC"));		
	}


	protected void init(String selFolder)	{
		this.selFolder = selFolder;
	}
	
	/**
	 * @see IDialogPage#createControl(Composite)
	 */
	public void createControl(Composite parent) {

		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout());
		GridData data = GridUtil.createFill();
		data.widthHint = 300;   	
		composite.setLayoutData(data);	
		composite.setLayoutData(data);

		Composite location = createLocationGroup(composite);

		createNameGroup(location);
		createSpacer(composite);
		createOptionsGroup(composite);
		setControl(composite);
		
		btnLocationBrowse.addListener(SWT.Selection, this);
		txtLocationFolder.addListener(SWT.Modify,this);
		txtDBName.addListener(SWT.Modify, this);
		txtDescription.addListener(SWT.Modify, this);
		setPageComplete(false);
				
		WorkbenchHelp.setHelp(txtLocationFolder, ContextIds.NEW_SYMDB_LOCATION);
		WorkbenchHelp.setHelp(txtDBName, ContextIds.NEW_SYMDB_NAME);
		WorkbenchHelp.setHelp(txtDescription, ContextIds.NEW_SYMDB_DESCRIPTION);
		WorkbenchHelp.setHelp(btnCreateFolderCheckbox, ContextIds.NEW_SYMDB_CREATE_FOLDER);
	}

	private Composite createLocationGroup(Composite composite){

		Composite locationGrp = new Composite(composite, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 3;
		layout.verticalSpacing = 2;

		GridData data = GridUtil.createHorizontalFill();
		data.widthHint = 300;   	
		locationGrp.setLayout(layout);
		locationGrp.setLayoutData(data);
					
		Label locationLabel = new Label(locationGrp, SWT.NONE);
		data = new GridData();
		//data.horizontalIndent = 10;
		locationLabel.setLayoutData(data);				
		locationLabel.setText(SDbPlugin.getResourceString("STR_SYMPTOM_DB_LOCATION"));
	
		// location name entry field
		txtLocationFolder = new Text(locationGrp, SWT.BORDER);
		data = GridUtil.createHorizontalFill();
		//data.grabExcessHorizontalSpace = true;
		txtLocationFolder.setLayoutData(data);
		txtLocationFolder.setText(selFolder);		
		
		// location folder browse button
		btnLocationBrowse = new Button(locationGrp, SWT.PUSH);
		btnLocationBrowse.setText(SDbPlugin.getResourceString("BROWSE"));
						
		return locationGrp;
	}
	
	
	
	public void createNameGroup(Composite parent){
	
		Label nameLabel = new Label(parent, SWT.NONE);
		nameLabel.setText(SDbPlugin.getResourceString("STR_SYMPTOM_DB_NAME"));
	
		txtDBName = new Text(parent, SWT.BORDER);
		txtDBName.setLayoutData(GridUtil.createHorizontalFill());

		Label dummy = new Label(parent, SWT.NONE);
		dummy.setVisible(false);
		
		Label descriptionLabel = new Label(parent, SWT.NONE);
		GridData data = new GridData();
		data.verticalAlignment = GridData.FILL;
		data.horizontalAlignment = GridData.FILL;
		descriptionLabel.setText(SDbPlugin.getResourceString("STR_SYMPTOM_DB_DESCRIPTION"));
		descriptionLabel.setLayoutData(data);


		txtDescription = new Text(parent, SWT.BORDER | SWT.MULTI);
		data = new GridData();
		data.verticalAlignment = GridData.FILL;
		data.horizontalAlignment = GridData.FILL;
		data.heightHint = 150;

		txtDescription.setLayoutData(data);
				
	}
	
	public void createOptionsGroup(Composite composite){

		Composite optionsGroup= new Composite(composite, SWT.NONE);
		GridLayout layout= new GridLayout();
		layout.marginHeight= 0;
		optionsGroup.setLayout(layout);
		optionsGroup.setLayoutData(GridUtil.createHorizontalFill());

		Label label = new Label(optionsGroup, SWT.NONE);
		label.setText(SDbPlugin.getResourceString("ExportDBWizardPage.options"));
		GridData data = new GridData();
		data.verticalAlignment = GridData.FILL;
		data.horizontalAlignment = GridData.FILL;
		label.setLayoutData(data);

		btnCreateFolderCheckbox= new Button(optionsGroup, SWT.CHECK | SWT.LEFT);
		btnCreateFolderCheckbox.setText(SDbPlugin.getResourceString("ExportDBWizardPage.create.folder.str")); 
	
	}	
	
   protected boolean allowNewContainerName(){
   		return false;
   }	

	private IContainer createContainer(IPath path)
	{
		IContainer container = null;
		IWorkspace workbench = ResourcesPlugin.getWorkspace();      
		int segCount = path.segmentCount();
	
		for(int idx=0; idx<segCount; idx++)
		{
			String seg = path.segment(idx);
						
			if(idx == 0)
			{//project
				IProject project = workbench.getRoot().getProject(path.uptoSegment(idx+1).toString());
				if(project == null || !project.exists())
				{//create the project
	
					try {
						project.create(null);
					   project.open(null);
				   }
				   catch (Exception e) { e.printStackTrace(); }
				}
				container = project;
			}
			else// (idx > 1)
			{//folder
				
				IFolder folder = workbench.getRoot().getFolder(path.uptoSegment(idx+1));
				if(folder == null || !folder.exists())
				{//create the folder
	
					try {
						folder.create(false, true, null);
					}
				   catch (Exception e) { e.printStackTrace(); }
				}
			    container = folder;
			}
			
		}
	
		try {
	
			container.getProject().refreshLocal(IResource.DEPTH_INFINITE, null);
		}catch(CoreException exc)
		{
			exc.printStackTrace();
		}   
		
		return container;
	}

	private void showResourceDialog()
	{
		IPath path = new Path(txtLocationFolder.getText().trim());
		IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
		IContainer cont = null;
		
		if(res != null && res.exists() && res instanceof IContainer)
		   cont = (IContainer)res;
		
		ContainerSelectionDialog dialog = new ContainerSelectionDialog(
			   getShell(), cont, true, SDbPlugin.getResourceString("STR_RES_DLG_MSG")
			   );
	
		if (dialog.open() == ContainerSelectionDialog.OK)
		{
			Object[] result = dialog.getResult();
			if (result != null && result.length == 1 && result[0] != null)
			{
				txtLocationFolder.setText(((IPath)result[0]).toOSString());		
			}
		}
		
	}

	protected boolean validateLocationGroup(){

		String locationFieldContents = txtLocationFolder.getText().trim();
		if(locationFieldContents.equals(""))
			return false;

		IWorkspace workspace = ResourcesPlugin.getWorkspace();
	
		if(locationFieldContents.charAt(0)!=File.separatorChar)
			locationFieldContents = File.separatorChar + locationFieldContents;
		IStatus pathStatus =
			workspace.validatePath(locationFieldContents, IResource.PROJECT | IResource.FOLDER);
		if (!pathStatus.isOK()) {
			setErrorMessage(pathStatus.getMessage());
			return false;
		}
	    
	    return true;
	
	}
	
	protected boolean validateNameGroup(){

		return !txtDBName.getText().trim().equals("") && checkDBName() && checkFilePath();
	}	
	
	protected boolean determinePageCompletion()
	{
		boolean complete = validateLocationGroup() && validateNameGroup();
			
		if (complete)
			setErrorMessage(null);
			
		return complete;
	}


	public boolean performFinish(){	
	
		IWorkspace workbench = ResourcesPlugin.getWorkspace();      	
		IContainer container = null;
		IPath path = new Path(txtLocationFolder.getText().trim());
		
		if(btnCreateFolderCheckbox.getSelection())
		{
			container = createContainer(path);
		}
		else
		{
			int idx = path.segmentCount();
			if(idx == 1)
			{//project
				container = workbench.getRoot().getProject(path.toString());
			}
			else// (idx > 1)
			{//folder
				
				container = workbench.getRoot().getFolder(path);
			}
			
		}
		
		if(container == null || !container.exists())
		{
			
			if(queryYesNoQuestion(SDbPlugin.getResourceString("STR_CONTAINER_NOT_FOUND")))
				container = createContainer(path);
			else
				return false;		
	
		}
		
	    // get location info and create a .trcdxmi doc.
	    
	    String fName =   container.getFullPath().toOSString().substring(1) + File.separator 
	                      + checkFileExtension();
		String sdbPath = new Path(fName).toString();	
	    URI uri = URI.createURI("platform:/resource/" + sdbPath);
		Resource dbDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
		EList ext = dbDoc.getContents();
		SDbPlugin.getDefault().getResourceSet().getResources().add(dbDoc); // prevents reloading later
	    		
		SDBFactory objFactory = SDbPlugin.getDefault().getSDBFactory();
			    
		SDBRuntime db = objFactory.createSDBRuntime();
		db.setName(txtDBName.getText());
		db.setDescription(txtDescription.getText());
		db.setSymptomUrl("");
		db.setLocalExternalFileLocation("");
		
		ext.add(db);
	    try {
	    	
	        Map options = new HashMap();		
	        options.put(XMIResource.OPTION_DECLARE_XML, Boolean.TRUE);
	        dbDoc.save(options);
	        container.refreshLocal(IResource.DEPTH_INFINITE, null);
	    }
	    catch (Exception e) {
	       e.printStackTrace();
	    }
		
		saveInPreferenceStore(sdbPath);		
		SDbPlugin.getDefault().getResourceSet().getResources().remove(dbDoc);
		return true;
	}

	private void saveInPreferenceStore(String sdbPath){
		IPreferenceStore store = AnalysisEnginePlugin.getPlugin().getPreferenceStore();
		String prefPath = store.getString(AnalysisEngineConstants.SYMPTOM_DB_PATH);		
		sdbPath = "/" + sdbPath;
		prefPath = prefPath.length()> 0 ?  prefPath + ";" + sdbPath + ",1" : sdbPath + ",1";
		store.setValue(AnalysisEngineConstants.SYMPTOM_DB_PATH, prefPath);
	}

	private String checkFileExtension(){
		String text = txtDBName.getText();
		if(text.endsWith(DB_EXT))
			if(text.length() != DB_EXT.length())
				return text;
			else
				return "error";	
		
		return text + DB_EXT;	
	}
	
	private boolean checkFilePath(){
	    
	    String dbName = checkFileExtension();
	    if(dbName.equals("error")){
			setErrorMessage(SDbPlugin.getResourceString("STR_INVALID_NAME_MSG"));
	    	return false;
	    }
	    	
	    String fName =   txtLocationFolder.getText() + File.separator 
	                      + dbName;
	    
		IPath path = new Path(fName);
		IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
	    
		if(res!=null){
			String message = SDbPlugin.getResourceString("STR_FILE_EXISTS_MSG");
			message = TString.change(message, "%1", fName);			
			setErrorMessage(message);
			return false;
		}
		
		return true;
	
	}
	
	private boolean checkDBName(){
		IWorkspace workspace = ResourcesPlugin.getWorkspace();
	
		IStatus nameStatus =
			workspace.validateName(txtDBName.getText(), IResource.FILE);
		if (!nameStatus.isOK()) {
			setErrorMessage(nameStatus.getMessage());
			return false;
		}
		return true;
	}

	/**
	 * @see Listener#handleEvent(Event)
	 */
	public void handleEvent(Event event) {

		if(event.widget == btnLocationBrowse)
		  showResourceDialog();
		  
		if(event.widget==txtLocationFolder) 
			if(txtLocationFolder.getText().trim().length()==0)
				setErrorMessage(SDbPlugin.getResourceString("STR_INVALID_LOCATION_MSG"));
			else	
				setErrorMessage(null);
				
		if(event.widget==txtDBName)
			if(txtDBName.getText().trim().length()==0)
				setErrorMessage(SDbPlugin.getResourceString("STR_INVALID_NAME_MSG"));
			else
				setErrorMessage(null);				
		
		setPageComplete(determinePageCompletion());		  
		
	}

}
