/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.http.runner;

import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

import org.eclipse.hyades.test.common.util.BaseString;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class HttpExecutor
{
	public HttpResponse execute(HttpRequest request)
	throws Exception
	{
		String stringURL = request.getURL();
		URL websiteURL = new URL(stringURL);

		long start = System.currentTimeMillis();
		HttpURLConnection connection = (HttpURLConnection)websiteURL.openConnection();
		connection.setDoOutput(true);
		connection.setDoInput(true);
		connection.setRequestMethod(request.getMethod());

		HttpHeader[] headers = request.getHeaders();
		for(int i = 0, maxi = headers.length; i < maxi; i++)
			connection.setRequestProperty(headers[i].getName(), BaseString.toString(headers[i].getValue()));
		 
		HttpResponse response = new HttpResponse(request);
		boolean errorDuringConnection = false;
		try
		{
			connection.connect();
			if(request.getBody() != null)
			{				
				OutputStream os = connection.getOutputStream();
				OutputStreamWriter writer = new OutputStreamWriter(os);
				writer.write(request.getBody());
				writer.close();
			}
		}
		catch(Throwable t)
		{
			errorDuringConnection = true;
			response.setDetail(BaseString.getStackTrace(t));
		}

		long end = System.currentTimeMillis();
		if(connection != null)
		{
			response.setContentLength(connection.getContentLength());
			response.setContentType(connection.getContentType());
			end = System.currentTimeMillis();
			
			if(errorDuringConnection)
			{
				response.setCode(-1);
			}
			else
			{
				try
				{
					response.setCode(connection.getResponseCode());
				}
				catch(FileNotFoundException fnfe)
				{
					response.setCode(HttpURLConnection.HTTP_NOT_FOUND);
				}
				catch(Throwable T)
				{
					response.setCode(-1);
				};
			}
		}

		response.setElapsedTime(end-start);
		return response;
	}
}
