/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.runner;


/**
 * The response is the object that stores the data that is
 * sent from the server to the client (usually a browser).
 * 
 * @author marcelop
 * @since 1.0.2
 */ 
public class HttpResponse
extends HttpElement
{
	private String contentType = null;
	private int contentLength = -1;
	private long elapsedTime;

	private int code;
	private String detail;
	private HttpRequest request;
	
	public HttpResponse(HttpRequest request)
	{
		this.request = request;
		request.setResponse(this);
	}
	
	public HttpRequest getRequest()
	{
		return request;
	}

	public void setDetail(String detail)
	{
		this.detail = detail;
	}	
	
	public String getDetail()
	{
		return detail;
	}

	public void setCode(int code)
	{
		this.code = code;
	}

	public int getCode()
	{
		return code;
	}

	/**
	 * @return
	 */
	public int getContentLength()
	{
		return contentLength;
	}

	/**
	 * @param contentLength
	 */
	public void setContentLength(int contentLength)
	{
		this.contentLength = contentLength;
	}

	/**
	 * @return
	 */
	public String getContentType()
	{
		return contentType;
	}

	/**
	 * @return
	 */
	public long getElapsedTime()
	{
		return elapsedTime;
	}

	/**
	 * @param elapsedTime
	 */
	public void setElapsedTime(long elapsedTime)
	{
		this.elapsedTime = elapsedTime;
	}

	/**
	 * @param contentType
	 */
	public void setContentType(String contentType)
	{
		this.contentType = contentType;
	}
}
