/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.common.internal.wizard;

import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.internal.util.TestCommonUtil;
import org.eclipse.hyades.test.ui.wizard.INewTestCaseWizard;
import org.eclipse.hyades.ui.internal.wizard.AttributeWizardPage;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;

/**
 * Wizard for test cases
 * 
 * @author marcelop
 * @since 1.0.2
 */
abstract public class TestCaseNewWizard
extends HyadesWizard implements INewTestCaseWizard
{
	private AttributeWizardPage attributeWizardPage;
	
	/**
	 * Constructor for TestCaseNewWizard
	 */
	public TestCaseNewWizard()
	{
		super();
	}
	
	abstract protected String getType();

	/**
	 * Returns the "name and description page" used by this wizard.
	 * @return NameDescriptionWizardPage
	 */
	protected AttributeWizardPage getAttributeWizardPage()
	{
		return attributeWizardPage;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#initPages()
	 */
	protected void initPages()
	{
		attributeWizardPage = new AttributeWizardPage("nameDescription");
	}
	
	/**
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish()
	{
		ITestCase testCase = TestCommonUtil.createTestCase((ITestSuite)getSelection().getFirstElement(), getType(), false, getAttributeWizardPage().getItemName());
		testCase.setDescription(getAttributeWizardPage().getItemDescription());

		return true;
	}
}
