/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.loaders.trace.TraceUtils.InvocationInfo;
import org.eclipse.hyades.loaders.trace.TraceUtils.InvocationPool;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCThread;

import java.util.Iterator;


/**
 * @author slavescu
 */
public class TraceMethodBaseLoader extends TraceXMLFragmentLoader {
    //~ Static fields/initializers -----------------------------------------------------------------

    protected static final String TICKET = "ticket";
    protected static final String STACK_DEPTH = "stackDepth";

    //~ Instance fields ----------------------------------------------------------------------------

    protected CallStackPerThread cs;
    protected InvocationPool invocationPool;
    protected TRCClass invokerClass;
    protected TRCClass invokerObjectClass;
    protected TRCFullMethodInvocation fullInvocation;
    protected TRCFullMethodInvocation fullInvoker;
    protected TRCFullTraceObject invokerObject;
    protected TRCMethod invokerMethod;
    protected double deltaBaseTime;
    protected double lastChildExitTime;
    protected double previousSiblingExitTime;
    protected long ticket;
    protected short stackDepth;

    //~ Methods ------------------------------------------------------------------------------------

    protected void updateTimeStatistics() {
        //update base time
        invokerMethod.setBaseTime(invokerMethod.getBaseTime() + deltaBaseTime);

        if (invokerObject != null) {
            invokerObject.setBaseTime(invokerObject.getBaseTime() + deltaBaseTime);

            if (invokerObjectClass != null) {
                invokerObjectClass.setInheritedBaseTime(invokerObjectClass.getInheritedBaseTime() + deltaBaseTime);
                invokerObjectClass.getPackage().setInheritedBaseTime(invokerObjectClass.getPackage().getInheritedBaseTime() + deltaBaseTime);
                invokerObjectClass.getPackage().getProcess().setInheritedBaseTime(invokerObjectClass.getPackage().getProcess().getInheritedBaseTime() + deltaBaseTime);
            }
        }

        invokerClass.setBaseTime(invokerClass.getBaseTime() + deltaBaseTime);
        invokerClass.getPackage().setBaseTime(invokerClass.getPackage().getBaseTime() + deltaBaseTime);
        invokerClass.getPackage().getProcess().setBaseTime(invokerClass.getPackage().getProcess().getBaseTime() + deltaBaseTime);

        //update cumulative time
        Iterator stackIter = cs.iterator();

        // current invocation should be on the stack for methodExit but not for methodEntry
        while (stackIter.hasNext()) {
            InvocationInfo invocationInfo = (InvocationInfo) stackIter.next();

            if (!invocationInfo.isObjectLocked()) {
                TRCFullTraceObject obj = invocationInfo.getObject();

                obj.setCumulativeTime(obj.getCumulativeTime() + deltaBaseTime);
            }

            TRCClass objectClass = invocationInfo.getObjectClass();

            if ((objectClass != null) && !invocationInfo.isObjectClassLocked()) {
                objectClass.setInheritedCumulativeTime(objectClass.getInheritedCumulativeTime() + deltaBaseTime);
                objectClass.getPackage().setInheritedCumulativeTime(objectClass.getPackage().getInheritedCumulativeTime() + deltaBaseTime);
                objectClass.getPackage().getProcess().setInheritedCumulativeTime(objectClass.getPackage().getProcess().getInheritedCumulativeTime() + deltaBaseTime);
            }

            if (!invocationInfo.isMethodLocked()) {
                invocationInfo.getMethod().setCumulativeTime(invocationInfo.getMethod().getCumulativeTime() + deltaBaseTime);
            }

            if (!invocationInfo.isClassLocked()) {
                invokerClass = invocationInfo.getTheClass();
                invokerClass.setCumulativeTime(invokerClass.getCumulativeTime() + deltaBaseTime);
                invokerClass.getPackage().setCumulativeTime(invokerClass.getPackage().getCumulativeTime() + deltaBaseTime);
                invokerClass.getPackage().getProcess().setCumulativeTime(invokerClass.getPackage().getProcess().getCumulativeTime() + deltaBaseTime);
            }
        }
    }
	protected TRCClass getExtendedClass(TRCObject anObject, TRCClass aClass)
	{
		if (anObject != null) {
		    if (anObject.getIsA() != aClass) {
		        if (anObject.getIsA() != theProcess.getClassClass())
		            return anObject.getIsA();
		    }
		}
		
		return null;
	}
	/**
	 * @param theThread
	 */
	protected void setMaxStackDepth(TRCThread theThread) {
		if(theThread==null)
			return;
		if(stackDepth > theThread.getMaxStackDepth())
			theThread.setMaxStackDepth(stackDepth);
	}
}
