/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodProperties;
import org.eclipse.hyades.models.trace.TRCSignatureNotation;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.models.trace.impl.TRCTraceObjectImpl;

/**
 * @author slavescu
 *
 */
public class XMLmethodDefLoader extends TraceXMLFragmentLoader {
    //~ Static fields/initializers -----------------------------------------------------------------

//	protected static final String NAME = "name";
    protected static final String START_LINE_NUM = "startLineNum";
    protected static final String SIGNATURE = "signature";
    protected static final String SIG_NOTATION = "sigNotation";
    protected static final String METHOD_ID = "methodId";

    //~ Instance fields ----------------------------------------------------------------------------

    protected String access;
    protected String name;
    protected String signature;
    protected TRCSignatureNotation sigNotation;
    protected int methodId;
    protected short endLineNum;
    protected short startLineNum;

    //~ Methods ------------------------------------------------------------------------------------

    public void addAttribute(String name, String value) {
        switch (LoadersUtils.getHashCode(name)) {
        case TraceConstants.METHOD_ID_int:
            methodId = Integer.parseInt(value);

            break;

        case TraceConstants.NAME_int:
            this.name = value;

            break;

        case TraceConstants.SIG_NOTATION_int:
            sigNotation = TRCSignatureNotation.get(value);

            break;

        case TraceConstants.SIGNATURE_int:
            signature = value;

            break;

        case TraceConstants.START_LINE_NUM_int:
            startLineNum = Short.parseShort(value);

            break;

        default:
            super.addAttribute(name, value);

            break;
        }
    }

    public void addYourselfInContext() {
        theProcess = getProcess();

        if (name == null) {
            name = UNKNOWN;
        }

        if (sigNotation == null) {
            sigNotation = TRCSignatureNotation.JNI_LITERAL;
        }

        theMethod = (TRCMethod) LookupServiceExtensions.getInstance().locate(context, TRCMethodImpl.class, LoadersUtils.getLookUpKey(methodId));

        //        theClass = (TRCClass) LookupServiceExtensions.getInstance().locate(context, TRCClassImpl.class, LoadersUtils.getLookUpKey(classIdRef));
        dispatchProcessMode(ProcessSteps.ALL);

        if (theMethod == null) {
            theMethod = TraceFactory.eINSTANCE.createTRCMethod();
            theMethod.setId(methodId);
            theMethod.setDefiningClass(theClass);
        }

        if (TraceUtils.isConstructor(name)) {
            theMethod.setModifier(theMethod.getModifier() | TRCMethodProperties.JAVA_CONSTRUCTOR);
        }

        theMethod.setName(TraceUtils.getMethodName(theMethod, name));
        theMethod.setSignature(TraceUtils.convertMethodSignature(theMethod, signature));
        theMethod.setNotation(sigNotation);
        theMethod.setLineNo(startLineNum);
    }

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        name = null;
        access = null;
        signature = null;
        startLineNum = 0;
        endLineNum = 0;
        sigNotation = null;
        methodId = 0;
    }

    protected void getTRCClass() {
        if (theClass == null) {
            if (theProcess.getThreads().size() > 0) {
                theClass = getClassByIdRef((TRCThread) theProcess.getThreads().get(theProcess.getThreads().size() - 1), TRCTraceObjectImpl.class,0);
            } else {
                theClass = getClassByIdRef(getThreadByIdRef(theProcess), TRCTraceObjectImpl.class,0);
            }
        }
    }

    /**
     *
     */
    protected void processEF(int step) {
        super.processEF(0);
        getTRCClass();
    }

    /**
     *
     */
    protected void processES(int step) {
        super.processES(step);
        getTRCClass();
    }

    /**
     *
     */
    protected void processHF(int step) {
        super.processHF(0);
        getTRCClass();
    }

    /**
     *
     */
    protected void processHS(int step) {
        super.processHS(0);
        getTRCClass();
    }
}
