/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCArrayClass;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl;


public final class XMLobjAllocLoader extends TraceXMLFragmentLoader {
    //~ Static fields/initializers -----------------------------------------------------------------

    protected static final String SIZE = "size";
    protected static final String IS_ARRAY = "isArray";
    protected static final String OBJ_ID = "objId";

    //~ Instance fields ----------------------------------------------------------------------------

    protected int isArray;
    protected int size;
    protected long objId;

    //~ Methods ------------------------------------------------------------------------------------

    public void addAttribute(String name, String value) {
        switch (LoadersUtils.getHashCode(name)) {
        case TraceConstants.OBJ_ID_int:
            objId = Long.parseLong(value);

            break;

        case TraceConstants.IS_ARRAY_int:
            isArray = Integer.parseInt(value);

            break;

        case TraceConstants.SIZE_int:
            size = Integer.parseInt(value);

            break;

        default:
            super.addAttribute(name, value);

            break;
        }
    }

    public void addYourselfInContext() {
        if (!loadToModel) {
            if (objId >= 0) {
                theProcess = getProcess();
                theThread = getThreadByIdRef(theProcess);
                updateTheClass(TRCHeapObjectImpl.class);
                updateVirtualObject(objId, size);
            }

            return;
        }

        createTRCObject();
    }

    public void initialize(HierarchyContext context, String name) {
        loadToModel = context.isLoadToModel();

        super.initialize(context, name);
        isArray = 0;
        objId = 0;
        size = 0;
    }

    //	private void updateSuperPackagesStatistics(TRCPackage thePackage, int s) {
    //		thePackage = thePackage.getParent();
    //		if(thePackage!=null)
    //		{
    //			thePackage.setTotalInstances(thePackage.getTotalInstances()+1);
    //			thePackage.setTotalSize(thePackage.getTotalSize()+s);
    //			updateSuperPackagesStatistics(thePackage,size);
    //		}
    //	}

    /**
     *
     */
    protected void processEF(int step) {
        super.processEF(step);

        switch (step) {
        case ProcessSteps.GET_CLASS:

            if (theClass != null) {
                break;
            }

            updateTheClass(TRCFullTraceObject.class);

            break;

        case ProcessSteps.GET_OBJECT:

            if ((theObject == null) || !(theObject instanceof TRCFullTraceObject)) {
                theObject = (TRCFullTraceObject) LookupServiceExtensions.getInstance().locate(context, TRCFullTraceObjectImpl.class, LoadersUtils.getLookUpKey(objId));
            }

            if (theObject == null) {
                theObject = TraceFactory.eINSTANCE.createTRCFullTraceObject();
            }

            //last update wins
            theObject.setId(objId);

            theObject.setSize(size);

            ((TRCFullTraceObject) theObject).setCreateTime(createDeltaTime());

            ((TRCFullTraceObject) theObject).setThread(theThread);
            theObject.setIsA(theClass);
            theObject.setProcess(theProcess);

            TraceUtils.removeVirtualObject(context, objId);

        default:
            break;
        }
    }

    /**
     *
     */
    protected void processES(int step) {
        super.processES(step);

        if (step == ProcessSteps.GET_CLASS) {
            if (theClass != null) {
                return;
            }

            updateTheClass(TRCFullTraceObject.class);
        }

        if ((step == ProcessSteps.GET_OBJECT) && (virtualObject == null)) {
            updateVirtualObject(objId, size);
        }
    }

    /**
     *
     */
    protected void processHF(int step) {
        super.processHF(step);

        switch (step) {
        case ProcessSteps.GET_CLASS:

            if (theClass != null) {
                break;
            }

            updateTheClass(TRCHeapObjectImpl.class);

            break;

        case ProcessSteps.GET_OBJECT:

            if ((theObject == null) || !(theObject instanceof TRCHeapObject)) {
                theObject = (TRCHeapObject) LookupServiceExtensions.getInstance().locate(context, TRCHeapObjectImpl.class, LoadersUtils.getLookUpKey(objId));
            }

            if (theObject == null) {
                theObject = TraceFactory.eINSTANCE.createTRCHeapObject();
            }

            //last update wins
            theObject.setId(objId);

            theObject.setSize(size);

            theObject.setIsA(theClass);
            theObject.setProcess(theProcess);

            if (virtualObject == null) {
                updateVirtualObject(objId, size);
            }

        default:
            break;
        }
    }

    /**
     *
     */
    protected void processHS(int step) {
        super.processHS(step);

        if (step == ProcessSteps.GET_CLASS) {
            if (theClass != null) {
                return;
            }

            updateTheClass(TRCHeapObjectImpl.class);
        }

        if ((step == ProcessSteps.GET_OBJECT) && (virtualObject == null)) {
            updateVirtualObject(objId, size);
        }
    }

    private void createTRCObject() {
        theProcess = getProcess();

        if (objId == 0) {
            objId = -classIdRef;
        }

        theThread = getThreadByIdRef(theProcess);

        if (objId >= 0) {
            dispatchProcessMode(ProcessSteps.GET_CLASS);
            dispatchProcessMode(ProcessSteps.GET_OBJECT);
            updateClassStatistics(size);
        }
    }

    private void updateClassStatistics(int s) {
        theClass.setTotalInstances(theClass.getTotalInstances() + 1);
        theClass.setTotalSize(theClass.getTotalSize() + s);

        TRCPackage thePackage = theClass.getPackage();

        thePackage.setTotalInstances(thePackage.getTotalInstances() + 1);
        thePackage.setTotalSize(thePackage.getTotalSize() + s);
        theProcess.setTotalInstances(theProcess.getTotalInstances() + 1);
        theProcess.setTotalSize(theProcess.getTotalSize() + s);

        //		updateSuperPackagesStatistics(thePackage,size);
    }

    private void updateTheClass(Class classObject) {
        theClass = getClassByIdRef(theThread, classObject, isArray);

        if ((isArray > 0) && (((TRCArrayClass) theClass).getElementType() == null)) {
            TRCClass elementType = (TRCClass) LookupServiceExtensions.getInstance().locate(context, TRCClassImpl.class, LoadersUtils.getLookUpKey(classIdRef));

            ((TRCArrayClass) theClass).setElementType(elementType);
        }
    }
}
