/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCAggregatedObjectReference;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.impl.TRCHeapDumpImpl;
import org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl;

import java.util.Iterator;
import java.util.List;


public final class XMLobjReferenceLoader extends TraceXMLFragmentLoader {
    //~ Static fields/initializers -----------------------------------------------------------------

    protected static final String FIELD_ID_REF = "fieldIdRef";
    protected static final String HEAP_DUMP_ID_REF = "heapDumpIdRef";
    protected static final String OWNER_OBJ_ID_REF = "ownerObjIdRef";
    protected static final String TARGET_OBJECT_ID_REF = "targetObjIdRef";

    //~ Instance fields ----------------------------------------------------------------------------

    protected Object oKey;
    protected Object tKey;
    protected TRCHeapObject ownerObject;
    protected TRCHeapObject targetObject;
    protected int fieldIdRef;
    protected long ownerObjIdRef;
    protected long targetObjIdRef;
    protected short heapDumpIdRef;
    private int ownerSize;
    private int targetSize;

    //~ Methods ------------------------------------------------------------------------------------

    public void addAttribute(String name, String value) {
        if (!loadToModel) {
            return;
        }

        switch (LoadersUtils.getHashCode(name)) {
        case TraceConstants.FIELD_ID_REF_int:
            fieldIdRef = Integer.parseInt(value);

            break;

        case TraceConstants.HEAP_DUMP_ID_REF_int:
            heapDumpIdRef = Short.parseShort(value);

            break;

        case TraceConstants.OWNER_OBJ_ID_REF_int:
            ownerObjIdRef = Long.parseLong(value);

            break;

        case TraceConstants.TARGET_OBJECT_ID_REF_int:
            targetObjIdRef = Long.parseLong(value);

            break;

        default:
            super.addAttribute(name, value);

            break;
        }
    }

    public void addYourselfInContext() {
        if (!loadToModel) {
            return;
        }

        oKey = LoadersUtils.getLookUpKey(ownerObjIdRef);
        tKey = LoadersUtils.getLookUpKey(targetObjIdRef);

        dispatchProcessMode(ProcessSteps.GET_OBJECT);
        dispatchProcessMode(ProcessSteps.GET_OBJECT_REF);
    }

    public void initialize(HierarchyContext context, String name) {
        loadToModel = context.isLoadToModel();

        if (!loadToModel) {
            return;
        }

        super.initialize(context, name);
        fieldIdRef = 0;
        ownerObjIdRef = 0;
        targetObjIdRef = 0;
        heapDumpIdRef = -1;
        ownerObject = null;
        targetObject = null;
        ownerSize = 0;
        targetSize = 0;
    }

    /**
     *
     */
    protected void processHF(int step) {
        super.processHF(step);

        switch (step) {
        case ProcessSteps.GET_OBJECT_REF:
            createObjectReference();

            break;

        case ProcessSteps.GET_OBJECT:
            ownerObject = (TRCHeapObject) getObjectByIdRef(ownerObjIdRef, TRCHeapObjectImpl.class);
            ownerSize = ownerObject.getSize();
            targetObject = (TRCHeapObject) getObjectByIdRef(targetObjIdRef, TRCHeapObjectImpl.class);
            targetSize = targetObject.getSize();

            break;

        default:
            break;
        }
    }

    /**
     *
     */
    protected void processHS(int step) {
        super.processHS(step);

        switch (step) {
        case ProcessSteps.GET_OBJECT_REF:
            createAggregatedObjectReference();

            break;

        case ProcessSteps.GET_OBJECT:
            ownerObject = (TRCHeapObject) LookupServiceExtensions.getInstance().locate(context, TRCHeapObjectImpl.class, oKey);

            if (ownerObject == null) {
                VirtualObjectInfo oOI = (VirtualObjectInfo) LookupServiceExtensions.getInstance().locate(context, VirtualObjectInfo.class, oKey);

                if (oOI != null) {
                    ownerSize = oOI.size;
                    theClass = oOI.myClass;

                    if (theClass != null) {
                        for (Iterator iter = theClass.getClassObjects().iterator(); iter.hasNext();) {
                            TRCObject element = (TRCObject) iter.next();

                            if (element instanceof TRCHeapObject) {
                                ownerObject = (TRCHeapObject) element;

                                break;
                            }
                        }
                    }
                }
            } else {
                ownerSize = ownerObject.getSize();
            }

            targetObject = (TRCHeapObject) LookupServiceExtensions.getInstance().locate(context, TRCHeapObjectImpl.class, tKey);

            if (targetObject == null) {
                VirtualObjectInfo tOI = (VirtualObjectInfo) LookupServiceExtensions.getInstance().locate(context, VirtualObjectInfo.class, tKey);

                if (tOI != null) {
                    targetSize = tOI.size;
                    theClass = tOI.myClass;

                    if (theClass != null) {
                        for (Iterator iter = theClass.getClassObjects().iterator(); iter.hasNext();) {
                            TRCObject element = (TRCObject) iter.next();

                            if (element instanceof TRCHeapObject) {
                                targetObject = (TRCHeapObject) element;

                                break;
                            }
                        }
                    }
                }
            } else {
                targetSize = targetObject.getSize();
            }

            break;

        default:
            break;
        }
    }

    private TRCHeapDump getHeapDumpById(short id) {
        theHeapDump = (TRCHeapDump) LookupServiceExtensions.getInstance().locate(context, TRCHeapDumpImpl.class, LoadersUtils.getLookUpKey(id));

        if (theHeapDump == null) {
            createHeapDump(id);
        }

        return theHeapDump;
    }

    private void createAggregatedObjectReference() {
		if(ownerObject==null || targetObject==null)
		{
			return;
		}
        theProcess = getProcess();
        theHeapDump = getHeapDumpById(heapDumpIdRef);

        TRCAggregatedObjectReference ref = null;
        List refList = ownerObject.getRefOwner();

        for (Iterator iter = refList.iterator(); iter.hasNext();) {
            TRCObjectReference element = (TRCObjectReference) iter.next();

            if (element instanceof TRCAggregatedObjectReference && (element.getTarget() == targetObject) && (element.getHeapDump() == theHeapDump)) {
                ref = (TRCAggregatedObjectReference) element;

                break;
            }
        }

        if (ref == null) {
            ref = TraceFactory.eINSTANCE.createTRCAggregatedObjectReference();

            ref.setHeapDump(theHeapDump);

            ref.setOwner(ownerObject);
            ref.setTarget(targetObject);
            ref.setOwnerSize(ownerSize);
            ref.setTargetSize(targetSize);
            ref.setCount(1);
        } else {
            ref.setOwnerSize(ref.getOwnerSize() + ownerSize);
            ref.setTargetSize(ref.getTargetSize() + targetSize);
            ref.setCount(ref.getCount() + 1);
        }
    }

    private void createHeapDump(short id) {
        theHeapDump = TraceFactory.eINSTANCE.createTRCHeapDump();
        theHeapDump.setId(id);
        theHeapDump.setEntryTime(createDeltaTime());
        theHeapDump.setProcess(theProcess);
    }

    private void createObjectReference() {
        theProcess = getProcess();
        theHeapDump = getHeapDumpById(heapDumpIdRef);

        TRCObjectReference objReference = TraceFactory.eINSTANCE.createTRCObjectReference();

        objReference.setOwner(ownerObject);
        objReference.setTarget(targetObject);
        objReference.setHeapDump(theHeapDump);
    }
}
