/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.impl.AbstractTRCCollectionBoundaryImpl;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCCollectionBoundary;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Collection Boundary</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCCollectionBoundaryImpl#getLastInvocation <em>Last Invocation</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCCollectionBoundaryImpl#getProcess <em>Process</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCCollectionBoundaryImpl#getLastClass <em>Last Class</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCCollectionBoundaryImpl#getLastThread <em>Last Thread</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCCollectionBoundaryImpl#getLastObject <em>Last Object</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCCollectionBoundaryImpl#getLastPackage <em>Last Package</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCCollectionBoundaryImpl#getLastMethod <em>Last Method</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCCollectionBoundaryImpl#getHeapDump <em>Heap Dump</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCCollectionBoundaryImpl extends AbstractTRCCollectionBoundaryImpl implements TRCCollectionBoundary {
	/**
	 * The cached value of the '{@link #getLastInvocation() <em>Last Invocation</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLastInvocation()
	 * @generated
	 * @ordered
	 */
	protected TRCMethodInvocation lastInvocation = null;

	/**
	 * The cached value of the '{@link #getLastClass() <em>Last Class</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLastClass()
	 * @generated
	 * @ordered
	 */
	protected TRCClass lastClass = null;

	/**
	 * The cached value of the '{@link #getLastThread() <em>Last Thread</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLastThread()
	 * @generated
	 * @ordered
	 */
	protected TRCThread lastThread = null;

	/**
	 * The cached value of the '{@link #getLastObject() <em>Last Object</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLastObject()
	 * @generated
	 * @ordered
	 */
	protected TRCObject lastObject = null;

	/**
	 * The cached value of the '{@link #getLastPackage() <em>Last Package</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLastPackage()
	 * @generated
	 * @ordered
	 */
	protected TRCPackage lastPackage = null;

	/**
	 * The cached value of the '{@link #getLastMethod() <em>Last Method</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLastMethod()
	 * @generated
	 * @ordered
	 */
	protected TRCMethod lastMethod = null;

	/**
	 * The cached value of the '{@link #getHeapDump() <em>Heap Dump</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHeapDump()
	 * @generated
	 * @ordered
	 */
	protected TRCHeapDump heapDump = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCCollectionBoundaryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCCollectionBoundary();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMethodInvocation getLastInvocation() {
		if (lastInvocation != null && lastInvocation.eIsProxy()) {
			TRCMethodInvocation oldLastInvocation = lastInvocation;
			lastInvocation = (TRCMethodInvocation)EcoreUtil.resolve(lastInvocation, this);
			if (lastInvocation != oldLastInvocation) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_INVOCATION, oldLastInvocation, lastInvocation));
			}
		}
		return lastInvocation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMethodInvocation basicGetLastInvocation() {
		return lastInvocation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLastInvocation(TRCMethodInvocation newLastInvocation) {
		TRCMethodInvocation oldLastInvocation = lastInvocation;
		lastInvocation = newLastInvocation;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_INVOCATION, oldLastInvocation, lastInvocation));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCProcess getProcess() {
		if (eContainerFeatureID != TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS) return null;
		return (TRCProcess)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProcess(TRCProcess newProcess) {
		if (newProcess != eContainer || (eContainerFeatureID != TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS && newProcess != null)) {
			if (EcoreUtil.isAncestor(this, newProcess))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newProcess != null)
				msgs = ((InternalEObject)newProcess).eInverseAdd(this, TracePackage.TRC_PROCESS__COLLECTION_BOUNDARY_POINTS, TRCProcess.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newProcess, TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS, newProcess, newProcess));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCClass getLastClass() {
		if (lastClass != null && lastClass.eIsProxy()) {
			TRCClass oldLastClass = lastClass;
			lastClass = (TRCClass)EcoreUtil.resolve(lastClass, this);
			if (lastClass != oldLastClass) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_CLASS, oldLastClass, lastClass));
			}
		}
		return lastClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCClass basicGetLastClass() {
		return lastClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLastClass(TRCClass newLastClass) {
		TRCClass oldLastClass = lastClass;
		lastClass = newLastClass;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_CLASS, oldLastClass, lastClass));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread getLastThread() {
		if (lastThread != null && lastThread.eIsProxy()) {
			TRCThread oldLastThread = lastThread;
			lastThread = (TRCThread)EcoreUtil.resolve(lastThread, this);
			if (lastThread != oldLastThread) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_THREAD, oldLastThread, lastThread));
			}
		}
		return lastThread;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread basicGetLastThread() {
		return lastThread;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLastThread(TRCThread newLastThread) {
		TRCThread oldLastThread = lastThread;
		lastThread = newLastThread;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_THREAD, oldLastThread, lastThread));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject getLastObject() {
		if (lastObject != null && lastObject.eIsProxy()) {
			TRCObject oldLastObject = lastObject;
			lastObject = (TRCObject)EcoreUtil.resolve(lastObject, this);
			if (lastObject != oldLastObject) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_OBJECT, oldLastObject, lastObject));
			}
		}
		return lastObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject basicGetLastObject() {
		return lastObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLastObject(TRCObject newLastObject) {
		TRCObject oldLastObject = lastObject;
		lastObject = newLastObject;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_OBJECT, oldLastObject, lastObject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCPackage getLastPackage() {
		if (lastPackage != null && lastPackage.eIsProxy()) {
			TRCPackage oldLastPackage = lastPackage;
			lastPackage = (TRCPackage)EcoreUtil.resolve(lastPackage, this);
			if (lastPackage != oldLastPackage) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_PACKAGE, oldLastPackage, lastPackage));
			}
		}
		return lastPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCPackage basicGetLastPackage() {
		return lastPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLastPackage(TRCPackage newLastPackage) {
		TRCPackage oldLastPackage = lastPackage;
		lastPackage = newLastPackage;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_PACKAGE, oldLastPackage, lastPackage));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMethod getLastMethod() {
		if (lastMethod != null && lastMethod.eIsProxy()) {
			TRCMethod oldLastMethod = lastMethod;
			lastMethod = (TRCMethod)EcoreUtil.resolve(lastMethod, this);
			if (lastMethod != oldLastMethod) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_METHOD, oldLastMethod, lastMethod));
			}
		}
		return lastMethod;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMethod basicGetLastMethod() {
		return lastMethod;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLastMethod(TRCMethod newLastMethod) {
		TRCMethod oldLastMethod = lastMethod;
		lastMethod = newLastMethod;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_COLLECTION_BOUNDARY__LAST_METHOD, oldLastMethod, lastMethod));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCHeapDump getHeapDump() {
		if (heapDump != null && heapDump.eIsProxy()) {
			TRCHeapDump oldHeapDump = heapDump;
			heapDump = (TRCHeapDump)EcoreUtil.resolve(heapDump, this);
			if (heapDump != oldHeapDump) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_COLLECTION_BOUNDARY__HEAP_DUMP, oldHeapDump, heapDump));
			}
		}
		return heapDump;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCHeapDump basicGetHeapDump() {
		return heapDump;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setHeapDump(TRCHeapDump newHeapDump) {
		TRCHeapDump oldHeapDump = heapDump;
		heapDump = newHeapDump;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_COLLECTION_BOUNDARY__HEAP_DUMP, oldHeapDump, heapDump));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS:
					return eBasicSetContainer(null, TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_PROCESS__COLLECTION_BOUNDARY_POINTS, TRCProcess.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_COLLECTION_BOUNDARY__NAME:
				return getName();
			case TracePackage.TRC_COLLECTION_BOUNDARY__START_TIME:
				return new Double(getStartTime());
			case TracePackage.TRC_COLLECTION_BOUNDARY__COLLECTION_MODE:
				return getCollectionMode();
			case TracePackage.TRC_COLLECTION_BOUNDARY__CONFIGURATION:
				if (resolve) return getConfiguration();
				return basicGetConfiguration();
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_INVOCATION:
				if (resolve) return getLastInvocation();
				return basicGetLastInvocation();
			case TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS:
				return getProcess();
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_CLASS:
				if (resolve) return getLastClass();
				return basicGetLastClass();
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_THREAD:
				if (resolve) return getLastThread();
				return basicGetLastThread();
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_OBJECT:
				if (resolve) return getLastObject();
				return basicGetLastObject();
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_PACKAGE:
				if (resolve) return getLastPackage();
				return basicGetLastPackage();
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_METHOD:
				if (resolve) return getLastMethod();
				return basicGetLastMethod();
			case TracePackage.TRC_COLLECTION_BOUNDARY__HEAP_DUMP:
				if (resolve) return getHeapDump();
				return basicGetHeapDump();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_COLLECTION_BOUNDARY__NAME:
				setName((String)newValue);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__START_TIME:
				setStartTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__COLLECTION_MODE:
				setCollectionMode((TRCCollectionMode)newValue);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__CONFIGURATION:
				setConfiguration((TRCConfiguration)newValue);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_INVOCATION:
				setLastInvocation((TRCMethodInvocation)newValue);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS:
				setProcess((TRCProcess)newValue);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_CLASS:
				setLastClass((TRCClass)newValue);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_THREAD:
				setLastThread((TRCThread)newValue);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_OBJECT:
				setLastObject((TRCObject)newValue);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_PACKAGE:
				setLastPackage((TRCPackage)newValue);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_METHOD:
				setLastMethod((TRCMethod)newValue);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__HEAP_DUMP:
				setHeapDump((TRCHeapDump)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_COLLECTION_BOUNDARY__NAME:
				setName(NAME_EDEFAULT);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__START_TIME:
				setStartTime(START_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__COLLECTION_MODE:
				setCollectionMode(COLLECTION_MODE_EDEFAULT);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__CONFIGURATION:
				setConfiguration((TRCConfiguration)null);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_INVOCATION:
				setLastInvocation((TRCMethodInvocation)null);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS:
				setProcess((TRCProcess)null);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_CLASS:
				setLastClass((TRCClass)null);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_THREAD:
				setLastThread((TRCThread)null);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_OBJECT:
				setLastObject((TRCObject)null);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_PACKAGE:
				setLastPackage((TRCPackage)null);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_METHOD:
				setLastMethod((TRCMethod)null);
				return;
			case TracePackage.TRC_COLLECTION_BOUNDARY__HEAP_DUMP:
				setHeapDump((TRCHeapDump)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_COLLECTION_BOUNDARY__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case TracePackage.TRC_COLLECTION_BOUNDARY__START_TIME:
				return startTime != START_TIME_EDEFAULT;
			case TracePackage.TRC_COLLECTION_BOUNDARY__COLLECTION_MODE:
				return collectionMode != COLLECTION_MODE_EDEFAULT;
			case TracePackage.TRC_COLLECTION_BOUNDARY__CONFIGURATION:
				return configuration != null;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_INVOCATION:
				return lastInvocation != null;
			case TracePackage.TRC_COLLECTION_BOUNDARY__PROCESS:
				return getProcess() != null;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_CLASS:
				return lastClass != null;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_THREAD:
				return lastThread != null;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_OBJECT:
				return lastObject != null;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_PACKAGE:
				return lastPackage != null;
			case TracePackage.TRC_COLLECTION_BOUNDARY__LAST_METHOD:
				return lastMethod != null;
			case TracePackage.TRC_COLLECTION_BOUNDARY__HEAP_DUMP:
				return heapDump != null;
		}
		return eDynamicIsSet(eFeature);
	}

} //TRCCollectionBoundaryImpl
