/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.ui.internal.model;

public class Increment
{
  private int value = 0;
  private double time = 0;
  private double actualTime = 0;
  private int weight = 0;

  void setWeight(double weightUnit, Increment previousIncrement)
  {
  	actualTime = time - previousIncrement.getTime();
  	if (actualTime<0)
  		actualTime=0;
    if (weight == 0)
      weight = new Double((actualTime / weightUnit)).intValue();
  }

  public int getWeight()
  {
    return weight;
  }
  private void setWeight(int newWeight)
  {
    weight = newWeight;
  }
  void setValue(int newValue)
  {
    value = newValue;
  }
  public int getValue()
  {
    return value;
  }
  void setTime(double newTime)
  {
    time = newTime;
  }
  public double getTime()
  {
    return time;
  }
  private void setDeltaTime(double newTime)
  {
    actualTime = newTime;
  }
  Increment duplicate()
  {
    Increment increment = new Increment();
    increment.setValue(this.getValue());
    increment.setTime(this.getTime());
    increment.setDeltaTime(this.getDeltaTime());
    increment.setWeight(this.getWeight());
    return increment;
  }
  public double getDeltaTime()
  {
    return actualTime;
  }
}
