/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.ui.internal.model;

import java.util.Map;

import org.eclipse.hyades.sd.ui.internal.util.LogCDrawUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;


public class NodeLink implements NodeConnection {
	
    int sourceConnectionType=26, targetConnectionType=26;
    boolean selected = false;
    boolean logRecordConection;
    
    public void init(int source,int target, boolean log){
    	
    	sourceConnectionType = source;
    	targetConnectionType = target;
    	logRecordConection = log;
    }
    
    public void drawSelf(GC gc, int width, ColumnNode columnNode, int timeUnit, int boxSpace, int startPosition, int nodeWidth, int xOffset, Map columnPassagesMap) {

		/*
		type = 0 - simpleLeftIn
		    1 - simpleRightIn
			2 - simpleLeftOut
			3 - simpleRightOut
			4 - synchLeft
			5 - synchRight
			6 - balkLeft
			7 - balkRight
			8 - timeoutLeft
			9 - timeoutRight
			10 - callLeft
			11 - callRight
			12 - asynchLeft
			13 - asynchRight
			14 - returnLeft
			15 - returnRight
			16 - returnLeftOut
			17 - returnRightOut
			18 - simpleSelfLeft
			19 - simpleSelfRight
			20 - returnSelfLeft
			21 - returnSelfRight
			22 - log record call left in
			23 - log record call right in
			26 - none
			27 - unknownLeft
			28 - unknownRight
		*/
		/*
		 * UNKNOWN = 0;
           SIMPLE = 1;
           SYNCHRONOUS = 2;
           BALKING = 3;
           TIMEOUT = 4;
           CALL = 5;
           ASYNCHRONOUS = 6;
           RETURN = 7;
        */
        
        
        int drawType = (columnNode==source)?sourceConnectionType:targetConnectionType;

		Color originalColor = gc.getForeground();
		
		if(isSelected())
		{
			if (!logRecordConection)
				gc.setForeground(LogCDrawUtils.getForegroundSelectedColor());
			else
				gc.setForeground(LogCDrawUtils.getLogHighLightColor());
		}
		else
		{
			if (!logRecordConection)
		   		gc.setForeground(LogCDrawUtils.getConnectionColor());
		   	else
				gc.setForeground(LogCDrawUtils.getLogConnectionColor());
		}
		
		int position = boxSpace	+ timeUnit*(getStartIncrementValue() - startPosition);
	    int sourcePosition=0;
		if(logRecordConection
		   && (target.getStartIncrement().getValue()<=source.getStartIncrement().getValue()
		   || target.getStartIncrement().getValue()>=source.getEndIncrement().getValue()))
		     sourcePosition = boxSpace + timeUnit * (source.getStartIncrement().getValue() - startPosition);
		
 		switch (drawType) {
			case (0) : //simpleLeftIn
				gc.drawLine(xOffset, position, xOffset+width / 2 - nodeWidth / 2, position);
				drawArrow(gc, 0, width, position, timeUnit, nodeWidth, xOffset);
				break;
			case (1) : //simpleRightIn
				gc.drawLine(xOffset+width, position, xOffset+width / 2 + nodeWidth / 2, position);
				drawArrow(gc, 1, width, position, timeUnit, nodeWidth, xOffset);
				break;
			case (2) : //simpleLeftOut
			    if(sourcePosition == 0)
				   gc.drawLine(xOffset+width / 2 - nodeWidth / 2, position, xOffset, position);
				else 
				   gc.drawLine(xOffset+width / 2 - nodeWidth / 2, sourcePosition, xOffset, sourcePosition);
				break;
			case (3) : //simpleRightOut
			    if(sourcePosition == 0)
				   gc.drawLine(xOffset+width / 2 + nodeWidth / 2, position, xOffset+width, position);
				else {
				   gc.drawLine(xOffset+width / 2 + nodeWidth / 2, sourcePosition, xOffset+width, sourcePosition);
				   
				   ColumnPassage passage = (ColumnPassage)(columnPassagesMap.get(this));
				   passage.setPassagePosition(source.getStartIncrement().getValue());
				   }
				   
				break;
			case (4) : //synchLeft
				gc.drawLine(xOffset, position, xOffset+width / 2 - nodeWidth / 2, position);
				drawArrow(gc, 0, width, position, timeUnit, nodeWidth, xOffset);
				drawDecoration(gc, 0, width, position, timeUnit, nodeWidth);
				break;
			case (5) : //synchRight
				gc.drawLine(xOffset+width, position, xOffset+width / 2 + nodeWidth / 2, position);
				drawArrow(gc, 1, width, position, timeUnit, nodeWidth, xOffset);
				drawDecoration(gc, 1, width, position, timeUnit, nodeWidth);
				break;
			case (6) : //balkLeft
				gc.drawLine(xOffset, position, xOffset+width / 2 - nodeWidth / 2, position);
				drawArrow(gc, 2, width, position, timeUnit, nodeWidth, xOffset);
				break;
			case (7) : //balkRight
				gc.drawLine(xOffset+width, position, xOffset+width / 2 + nodeWidth / 2, position);
				drawArrow(gc, 3, width, position, timeUnit, nodeWidth, xOffset);
				break;
			case (8) : //timeoutLeft
				gc.drawLine(xOffset, position, xOffset+width / 2 - nodeWidth / 2, position);
				drawArrow(gc, 0, width, position, timeUnit, nodeWidth, xOffset);
				drawDecoration(gc, 2, width, position, timeUnit, nodeWidth);
				break;
			case (9) : //timeoutRight
				gc.drawLine(xOffset+width, position, xOffset+width / 2 + nodeWidth / 2, position);
				drawArrow(gc, 1, width, position, timeUnit, nodeWidth, xOffset);
				drawDecoration(gc, 3, width, position, timeUnit, nodeWidth);
				break;
			case (10) : //callLeft
				gc.drawLine(xOffset, position, xOffset+width / 2 - nodeWidth / 2, position);
				drawArrow(gc, 4, width, position, timeUnit, nodeWidth, xOffset);
				break;
			case (11) : //callRight
				gc.drawLine(xOffset+width, position, xOffset+width / 2 + nodeWidth / 2, position);
				drawArrow(gc, 5, width, position, timeUnit, nodeWidth, xOffset);
				break;
			case (12) : //asynchLeft
				gc.drawLine(xOffset, position, xOffset+width / 2 - nodeWidth / 2, position);
				drawArrow(gc, 6, width, position, timeUnit, nodeWidth, xOffset);
				break;
			case (13) : //asynchRight
				gc.drawLine(xOffset+width, position, xOffset+width / 2 + nodeWidth / 2, position);
				drawArrow(gc, 7, width, position, timeUnit, nodeWidth, xOffset);
				break;
			case (14) : //returnLeft
				gc.setLineStyle(SWT.LINE_DOT);
				gc.drawLine(xOffset, position, xOffset+width / 2 - nodeWidth / 2, position);
				gc.setLineStyle(SWT.LINE_SOLID);
				drawArrow(gc, 0, width, position, timeUnit, nodeWidth, xOffset);
				break;
			case (15) : //returnRight
				gc.setLineStyle(SWT.LINE_DOT);
				gc.drawLine(xOffset+width, position, xOffset+width / 2 + nodeWidth / 2, position);
				gc.setLineStyle(SWT.LINE_SOLID);
				drawArrow(gc, 1, width, position, timeUnit, nodeWidth, xOffset);
				break;
			case (16) : //returnLeftOut
				gc.setLineStyle(SWT.LINE_DOT);
				gc.drawLine(xOffset+width / 2 - nodeWidth / 2, position, xOffset, position);
				gc.setLineStyle(SWT.LINE_SOLID);
				break;
			case (17) : //returnRightOut
				gc.setLineStyle(SWT.LINE_DOT);
				gc.drawLine(xOffset+width / 2 + nodeWidth / 2, position, xOffset+width, position);
				gc.setLineStyle(SWT.LINE_SOLID);
				break;
			case (18) : //simpleSelfLeft
				gc.drawLine(xOffset+width / 2 - nodeWidth / 2, position, xOffset+width / 4, position);
				gc.drawLine(xOffset+width / 4, position, xOffset+width / 4, position + timeUnit/2);
				gc.drawLine(
				   xOffset+width / 4,
				   position + timeUnit/2,
				   xOffset+width / 2 - nodeWidth / 2,
				   position + timeUnit/2);
				drawArrow(gc, 0, width, position + timeUnit/2, timeUnit, nodeWidth, xOffset);
				break;
			case (19) : //simpleSelfRight
				gc.drawLine(xOffset+width / 2 + nodeWidth / 2, position, xOffset+3 * width / 4, position);
				if(getStartIncrementValue()==getEndIncrementValue()){
				   gc.drawLine(xOffset+3 * width / 4, position, xOffset+3 * width / 4, position + timeUnit/2);
				   gc.drawLine(
					  xOffset+3 * width / 4,
					  position + timeUnit/2,
					  xOffset+width / 2 + nodeWidth / 2,
					  position + timeUnit/2);
				   drawArrow(gc, 1, width, position + timeUnit/2, timeUnit, nodeWidth, xOffset);
				}
				break;
			case (20) : //returnSelfLeft
				gc.setLineStyle(SWT.LINE_DOT);
				gc.drawLine(xOffset+width / 2 - nodeWidth / 2, position - timeUnit/2, xOffset+width / 4, position - timeUnit/2);
				gc.drawLine(xOffset+width / 4, position - timeUnit/2, xOffset+width / 4, position);
				gc.drawLine(
					xOffset+width / 4,
					position,
					xOffset+width / 2 - nodeWidth / 2,
					position);
				gc.setLineStyle(SWT.LINE_SOLID);
				drawArrow(gc, 0, width, position, timeUnit, nodeWidth, xOffset);
				break;
			case (21) : //returnSelfRight
				gc.setLineStyle(SWT.LINE_DOT);
				gc.drawLine(xOffset+width / 2 + nodeWidth / 2, position - timeUnit/2, xOffset+3 * width / 4, position - timeUnit/2);
				gc.drawLine(xOffset+3 * width / 4, position - timeUnit/2, xOffset+3 * width / 4, position);
				gc.drawLine(
					xOffset+3 * width / 4,
					position,
					xOffset+width / 2 + nodeWidth / 2,
					position);
				gc.setLineStyle(SWT.LINE_SOLID);
				drawArrow(gc, 1, width, position, timeUnit, nodeWidth, xOffset);
				break;
			case (22) : //log record call left in
			    if(sourcePosition == 0)
			    	gc.drawLine(xOffset, position, xOffset+width / 2 - nodeWidth / 2, position);
			    else{
			        gc.drawLine(xOffset,sourcePosition,xOffset+width/8,sourcePosition);
			        gc.drawLine(xOffset+width/8,sourcePosition, xOffset+width/8,position);
			        gc.drawLine(xOffset+width/8,position,xOffset+width/2-nodeWidth,position);
			    }
			    drawArrow(gc, 0, width, position, timeUnit, nodeWidth, xOffset);
			    break;
			case (23) : //log record call right in
			    if(sourcePosition == 0)
			       gc.drawLine(xOffset+width, position, xOffset+width / 2 + nodeWidth / 2, position);
			    else{
			       gc.drawLine(xOffset+width,sourcePosition,xOffset+7*width/8,sourcePosition);
			       gc.drawLine(xOffset+7*width/8,sourcePosition,xOffset+7*width/8,position);
			       gc.drawLine(xOffset+7*width/8,position,xOffset+width / 2 + nodeWidth / 2, position);
				   if (sourcePosition!=position)
				   {
					   ((ColumnPassage)(columnPassagesMap.get(this))).setPassagePosition(source.getStartIncrement().getValue());
				   }
			    }
			    drawArrow(gc, 1, width, position, timeUnit, nodeWidth, xOffset);
			    break;
			case (26) : //right in call to same column target side
			    if(getStartIncrementValue()!=getEndIncrementValue()){
			    	int targetPosition = boxSpace + timeUnit * (getEndIncrementValue() - startPosition);
			       	gc.drawLine(xOffset+3 * width / 4, position, xOffset+3 * width / 4, targetPosition);
			       	gc.drawLine(xOffset+3 * width / 4,targetPosition,xOffset+width / 2 + nodeWidth / 2,targetPosition);
				    drawArrow(gc, 1, width, position + timeUnit/2, timeUnit, nodeWidth, xOffset);
			    }
				break;
			case (27) : //unknownLeftIn
				gc.drawLine(xOffset, position, xOffset+width / 2 - nodeWidth / 2, position);
				gc.drawString("?", xOffset+width / 2 - 3 * nodeWidth / 2, position - 3 * timeUnit / 4);
				break;
			case (28) : //unknownRightIn
				gc.drawLine(xOffset+width, position, xOffset+width / 2 + nodeWidth / 2, position);
				gc.drawString("?", xOffset+width / 2 + 3 * nodeWidth / 4, position - 3 * timeUnit / 4);
				break;
			default :
				System.out.println("WRONG INDEX FOR LINK!!!!!");
				break;
		}
		gc.setForeground(originalColor);
		originalColor.dispose();

	}
	
	private void drawArrow(GC gc, int type, int width, int position, int timeUnit, int nodeWidth, int xOffset) {

		switch (type) {
			case (0) : //simpleLeft
				gc.drawLine(
					xOffset + width / 2 - nodeWidth / 2,
					position,
					xOffset + width / 2 - 3 * nodeWidth / 2,
					position - timeUnit / 2);
				gc.drawLine(
					xOffset + width / 2 - nodeWidth / 2,
					position,
					xOffset + width / 2 - 3 * nodeWidth / 2,
					position + timeUnit / 2);
				break;
			case (1) : //simpleRight
				gc.drawLine(
					xOffset + width / 2 + nodeWidth / 2,
					position,
					xOffset + width / 2 + 3 * nodeWidth / 2,
					position - timeUnit / 2);
				gc.drawLine(
					xOffset + width / 2 + nodeWidth / 2,
					position,
					xOffset + width / 2 + 3 * nodeWidth / 2,
					position + timeUnit / 2);
				break;
			case (2) : //balkingLeft
				gc.drawLine(
					xOffset + width / 2 - nodeWidth / 2,
					position - timeUnit / 3,
					xOffset + width / 2 - 2 * nodeWidth,
					position - timeUnit / 3);
				gc.drawLine(
					xOffset + width / 2 - 2 * nodeWidth,
					position - timeUnit / 3,
					xOffset + width / 2 - nodeWidth,
					position - timeUnit / 2);
				gc.drawLine(
					xOffset + width / 2 - 2 * nodeWidth,
					position - timeUnit / 3,
					xOffset + width / 2 - nodeWidth,
					position - timeUnit / 6);
				break;
			case (3) : //balkingRight
				gc.drawLine(
					xOffset + width / 2 + nodeWidth / 2,
					position - timeUnit / 3,
					xOffset + width / 2 + 2 * nodeWidth,
					position - timeUnit / 3);
				gc.drawLine(
					xOffset + width / 2 + 2 * nodeWidth,
					position - timeUnit / 3,
					xOffset + width / 2 + nodeWidth,
					position - timeUnit / 2);
				gc.drawLine(
					xOffset + width / 2 + 2 * nodeWidth,
					position - timeUnit / 3,
					xOffset + width / 2 + nodeWidth,
					position - timeUnit / 6);
				break;
			case (4) : //callLeft
				int[] corners4 =
					{
						xOffset + width / 2 - nodeWidth / 2,
						position,
						xOffset + width / 2 - 3 * nodeWidth / 2,
						position + timeUnit / 2,
						xOffset + width / 2 - 3 * nodeWidth / 2,
						position - timeUnit / 2 };
				gc.drawPolygon(corners4);
				int[] cornersFill4 =
					{
						xOffset + width / 2 - nodeWidth / 2 + 1,
						position,
						xOffset + width / 2 - 3 * nodeWidth / 2,
						position + timeUnit / 2,
						xOffset + width / 2 - 3 * nodeWidth / 2,
						position - timeUnit / 2 };
			    if(isSelected())
			    {
		           	if (!logRecordConection)
						gc.setBackground(LogCDrawUtils.getForegroundSelectedColor());
					else
						gc.setBackground(LogCDrawUtils.getLogHighLightColor());
			    }
		        else
		        {
		        	if (!logRecordConection)
				   		gc.setBackground(LogCDrawUtils.getConnectionColor());
					else
						gc.setBackground(LogCDrawUtils.getLogConnectionColor());
		        }
				gc.fillPolygon(cornersFill4);
				gc.setBackground(LogCDrawUtils.getBackgroundColor());
				break;
			case (5) : //callRight
				int[] corners5 =
					{
						xOffset + width / 2 + nodeWidth / 2,
						position,
						xOffset + width / 2 + 3 * nodeWidth / 2,
						position + timeUnit / 2,
						xOffset + width / 2 + 3 * nodeWidth / 2,
						position - timeUnit / 2 };
				gc.drawPolygon(corners5);

				int[] cornersFill5 =
					{
						xOffset + width / 2 + nodeWidth / 2,
						position,
						xOffset + width / 2 + 3 * nodeWidth / 2,
						position + timeUnit / 2,
						xOffset + width / 2 + 3 * nodeWidth / 2,
						position - timeUnit / 2 };
				if(isSelected()) 
				{
					if (!logRecordConection)
				   		gc.setBackground(LogCDrawUtils.getForegroundSelectedColor());
				   	else
						gc.setBackground(LogCDrawUtils.getLogHighLightColor());
				}
				else
				{
					if (!logRecordConection)
				   		gc.setBackground(LogCDrawUtils.getConnectionColor());
				   	else
						gc.setBackground(LogCDrawUtils.getLogConnectionColor());
				}	
				gc.fillPolygon(cornersFill5);
				gc.setBackground(LogCDrawUtils.getBackgroundColor());
				break;
			case (6) : //asynchLeft
				gc.drawLine(
					xOffset + width / 2 - nodeWidth / 2,
					position,
					xOffset + width / 2 - 3 * nodeWidth / 2,
					position - timeUnit / 2);
				break;
			case (7) : //asynchRight
				gc.drawLine(
					xOffset + width / 2 + nodeWidth / 2,
					position,
					xOffset + width / 2 + 3 * nodeWidth / 2,
					position - timeUnit / 2);
				break;
			default :
				System.out.println("WRONG INDEX FOR ARROW!!!!!");
				break;
		}
	}

	private void drawDecoration(GC gc, int type, int width, int position, int timeUnit, int nodeWidth) {

		switch (type) {
			case (0) : //synchLef
				gc.drawLine(
					width / 2 - 3 * nodeWidth / 2 - 3 * nodeWidth / 8,
					position - timeUnit / 2,
					width / 2 - 5 * nodeWidth / 2 - 3 * nodeWidth / 8,
					position + timeUnit / 2);
				gc.drawLine(
					width / 2 - 3 * nodeWidth / 2 - 3 * nodeWidth / 8,
					position + timeUnit / 2,
					width / 2 - 5 * nodeWidth / 2 - 3 * nodeWidth / 8,
					position - timeUnit / 2);
				break;
			case (1) : //synchRight
				gc.drawLine(
					width / 2 + 3 * nodeWidth / 2 + 3 * nodeWidth / 8,
					position - timeUnit / 2,
					width / 2 + 5 * nodeWidth / 2 + 3 * nodeWidth / 8,
					position + timeUnit / 2);
				gc.drawLine(
					width / 2 + 3 * nodeWidth / 2 + 3 * nodeWidth / 8,
					position + timeUnit / 2,
					width / 2 + 5 * nodeWidth / 2 + 3 * nodeWidth / 8,
					position - timeUnit / 2);
				break;
			case (2) : //timeoutLeft
				gc.drawOval(
					3 * width / 8 - 3 * timeUnit / 4,
					position - timeUnit - 1,
					3 * timeUnit / 4,
					3 * timeUnit / 4);
				break;
			case (3) : //timeoutRight
				gc.drawOval(
					5 * width / 8,
					position - timeUnit - 1,
					3 * timeUnit / 4,
					3 * timeUnit / 4);
				break;
			default :
				System.out.println("WRONG INDEX FOR DECORATION!!!!!");
				break;
		}
	}
	
	public boolean isLogRecordConection(){
		
	   return logRecordConection;	
	}
	
    //NodeConnection implementation ->begin
    private String name = null;
    private String shortName = null;
    private String secondaryName = null;
    
    private int type = 0;
     private Increment startIncrement = null;
    private Increment endIncrement = null;
    
    //private Object userArea = null;
    private GraphNode source;
    private GraphNode target;
    
    /**
   * @return String
   * @since November 23, 2001
   * @roseuid 3BFEC43F0054
   */
  public String getName()
  {
    return name;
  }

  /**
   * @param inputName
   * @since November 23, 2001
   * @roseuid 3BFEC4440173
   */
  public void setName(String inputName)
  {
    name = inputName;
  }
  /**
    * @return String
    * @since December 17, 2001
    */
  public String getShortName()
  {
    return shortName;
  }
  public void setShortName(String name)
  {
    shortName = name;
  }
  /**
  * @return String
  * @since December 17, 2001
  */
  public String getSecondaryName()
  {
    return secondaryName;
  }
  public void setSecondaryName(String name)
  {
    secondaryName = name;
  }

  /**
   * @return int
   * @since November 23, 2001
   * @roseuid 3BFEC44903DD
   */
  public int getType()
  {
    return type;
  }

  /**
   * @param inputType
   * @since November 23, 2001
   * @roseuid 3BFEC44F01AB
   */
  public void setType(int inputType)
  {
    type = inputType;
  }

  /**
   * @return double
   * @since November 23, 2001
   * @roseuid 3BFEC4550178
   */
  public double getStartTime()
  {
    return 0.0;//startTime;
  }

  /**
   * @param time
   * @since November 23, 2001
   * @roseuid 3BFEC45C004B
   */
  public void setStartTime(double time)
  {
    //startTime = time;
    startIncrement = getSource().getGraph().addIncrementAppendDup(time);
  }

  public void setStartIncrement(Increment increment)
  {
    //startTime = increment.getTime();
    startIncrement = increment;
  }
  /**
   * @return double
   * @since November 23, 2001
   * @roseuid 3BFEC4610279
   */
  public double getEndTime()
  {
    return 0.0;//endTime;
  }

  /**
   * @param time
   * @since November 23, 2001
   * @roseuid 3BFEC4670368
   */
  public void setEndTime(double time)
  {
    //endTime = time;
    endIncrement = getSource().getGraph().addIncrementAppendDup(time);
  }
  public void setEndIncrement(Increment increment)
  {
     endIncrement = increment;
  }
  /**
  * @return long
  * @since December 13, 2001
  * 
  */
  public Increment getStartIncrement()
  {

    return startIncrement;

  }

  public int getStartIncrementValue()
  {
    if (startIncrement != null)
      return startIncrement.getValue();
    else
      return 0;

  }
  /**
   * @return int
   * @since December 13, 2001
   * 
   */
  public Increment getEndIncrement()
  {

    return endIncrement;

  }

  public int getEndIncrementValue()
  {
    if (endIncrement != null)
      return endIncrement.getValue();
    else
      return 0;

  }

  /**
   * @return com.ibm.etools.pd.sd.model.GraphNode
   * @since November 23, 2001
   * @roseuid 3BFEC46E01A6
   */
  public GraphNode getSource()
  {
    return source;
  }

  /**
   * @param node
   * @since November 23, 2001
   * @roseuid 3BFEC47401C2
   */
  public void setSource(GraphNode node)
  {
    source = node;
  }

  /**
   * @return com.ibm.etools.pd.sd.model.GraphNode
   * @since November 23, 2001
   * @roseuid 3BFEC47B006E
   */
  public GraphNode getTarget()
  {
    return target;
  }

  /**
   * @param node
   * @since November 23, 2001
   * @roseuid 3BFEC480035A
   */
  public void setTarget(GraphNode node)
  {
    target = node;
  }

  /**
   * @return Object
   * @since November 23, 2001
   * @roseuid 3BFED9700036
   */
  public Object getUserArea()
  {
    return null;//userArea;
  }

  /**
   * @param area
   * @since November 23, 2001
   * @roseuid 3BFED97F01FA
   */
  public void setUserArea(Object area)
  {
    //userArea = area;
  }
  
  public void setSelected(boolean state){
  	if (state == false)
	   selected = state;	
	   else 
	   selected = state;	
	}
	
  public boolean isSelected(){
     return selected;	
  }

}
