/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logc.internal.extensions;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.logc.*;
import org.eclipse.hyades.logc.extensions.*;
import org.eclipse.hyades.logs.correlators.*;
import org.eclipse.hyades.models.cbe.CBEAssociatedEvent;
import org.eclipse.hyades.models.cbe.CBEFactory;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEAssociationEngine;

/**
 *
 */
public class TimeBasedLogRecordCorrelationEngineImpl implements ILogRecordCorrelationEngine{
	
	String correlationName;
	CBEAssociationEngine correlationEngine;
	
	public TimeBasedLogRecordCorrelationEngineImpl(){
		
	   	
	}
	
	public void correlate(EList list){
		
		correlationEngine=null;
		correlationName = LogCorrelatorPlugin.getResourceString("CORR_NAME");
		for(int i=0; i<list.size();i++){
		   if(list.get(i)!=null){
		   	   EList recordList = ((RecordList)list.get(i)).getList();
		   	   for(int k=0; k<recordList.size(); k++){
		   	      if(recordList.get(k)!=null){
		   	      	
					//Need to reset the previous correlations in case the delta time was adjusted
					EList correlators = ((CBECommonBaseEvent)recordList.get(k)).getAssociatedEvents();

					for (int j=correlators.size()-1; j>=0; j--){		   	      	    
					    if(correlators.get(j)!=null 
					      && ((CBEAssociatedEvent)correlators.get(j)).getAssociationEngine()!=null
					      && ((CBEAssociatedEvent)correlators.get(j)).getAssociationEngine().getName()!=null 
					      && ((CBEAssociatedEvent)correlators.get(j)).getAssociationEngine().getName().equals(correlationName)){

					       correlators.remove(j);		   	      	       	   	     
					  	      
					     }
					 }
				  	  
		   	         setPartners(recordList.get(k),list,i);
		   	      }
		   	   }
		   }	
		}		
	}
	
	private void setPartners(Object art, EList list, int currentListIndex){
		
		CBECommonBaseEvent artifact = (CBECommonBaseEvent)art;

	   	double artifactTime = CBEUtils.computeAdjustedCreationTime(artifact);
	   	EList recordList = null;
		CBEAssociatedEvent correlationType = null;
	   	CBEFactory artifactsFactory = CBEFactory.eINSTANCE;
	   	
	   	 	         
	   	for(int i=0; i<list.size();i++){
	   	      recordList = ((RecordList)list.get(i)).getList();
	   	      if(recordList != null){
	   	         for(int k=0; k<recordList.size(); k++){
		   	        if(recordList.get(k)!=null){
		   	        	
		   	           if(i>currentListIndex || (i==currentListIndex && recordList.get(k)!=art)){

		   	      	      if(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)recordList.get(k))==artifactTime
		   	      	         && recordList.get(k)!=art){	

		   	      	         EList correlators = artifact.getAssociatedEvents();
		   	      	         for (int j=0;j<correlators.size();j++){
		   	      	    
		   	      	       	       if(correlators.get(j)!=null 
		   	      	       	          && ((CBEAssociatedEvent)correlators.get(j)).getAssociationEngine()!=null
		   	      	       	          && ((CBEAssociatedEvent)correlators.get(j)).getAssociationEngine().getName()!=null 
		   	      	       	          && ((CBEAssociatedEvent)correlators.get(j)).getAssociationEngine().getName().equals(correlationName)){
		   	      	       	   	         correlationType = (CBEAssociatedEvent)correlators.get(j);

		   	      	       	   	         break;
		   	      	       	       }
		   	      	         }
		   	      	         if(correlationType == null){
		   	      	            correlationType = artifactsFactory.createCBEAssociatedEvent();
		   	      	            if (correlationEngine == null) {
										correlationEngine=artifactsFactory.createCBEAssociationEngine();
										correlationEngine.setType(LogCorrelatorPlugin.getResourceString("CORR_TYPE"));
										correlationEngine.setName(LogCorrelatorPlugin.getResourceString("CORR_NAME"));
										artifact.getAgent().eResource().getContents().add(correlationEngine);		
 						 	     } 
		   	      	             correlationType.setAssociationEngine(correlationEngine);

		   	      	       
		   	      	             correlators.add(correlationType);
		   	      	         }	
		   	      	         if(!correlationType.getResolvedEvents().contains((CBECommonBaseEvent)recordList.get(k)))
		   	      	       	    correlationType.getResolvedEvents().add((CBECommonBaseEvent)recordList.get(k));

		   	      	       }
	   	      	         
		   	           }
		   	        }	
	   	         }
	   	      }
	   	}
	}
}
