/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.http.internal.importWizard;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.help.WorkbenchHelp;

import org.eclipse.emf.ecore.resource.Resource;

import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.http.internal.preferences.HttpPreferenceUtil;
import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;

public class HttpImportWizard extends Wizard implements IImportWizard
{
	private HttpImportPage page1;
	protected boolean succeed;

	/**
	 * Constructor for HttpImportWizard.
	 */
	public HttpImportWizard()
	{
		super();
		setNeedsProgressMonitor(true);
	}

	/*
	 * @see IWorkbenchWizard#init(IWorkbench, IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection)
	{
		setWindowTitle(TestHttpPlugin.getString("Importer.WindowTitle"));
	}

	public void addPages()
	{
		page1 = new HttpImportPage();
		addPage(page1);
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#createPageControls(Composite)
	 */
	public void createPageControls(Composite pageContainer)
	{
		super.createPageControls(pageContainer);
		
		WorkbenchHelp.setHelp(page1.getControl(), TestHttpPlugin.getID() + ".ctst0200");
	}

	public boolean canFinish()
	{
		return page1.isPageComplete();
	}

	/*
	 * @see IWizard#performFinish()
	 */
	public boolean performFinish()
	{
		boolean res = false;
		Composite parent = getShell();
		parent.setCursor(new Cursor(parent.getDisplay(), SWT.CURSOR_WAIT));

		String inFile = page1.getFrom();
		IPath outFolder = page1.getTo();
		String baseName = page1.getTestcaseBaseName();

		// this could be handled in the import page instead - if here, then was a
		// committed action; otherwise 
		HttpPreferenceUtil.getInstance().addToInfileHistory(inFile);
		HttpPreferenceUtil.getInstance().addToTargetHistory(outFolder.toString());

		final HttpRequestFromXML loader = new HttpRequestFromXML();
		loader.setOutputFolder(outFolder);
		loader.setScriptFile(inFile);
		loader.setTestSuiteBaseName(baseName);
		
		succeed = false;
		IRunnableWithProgress operation = new WorkspaceModifyOperation()
		{
			protected void execute(IProgressMonitor monitor) 
			throws CoreException, InvocationTargetException, InterruptedException
			{
				succeed = loader.load();
			}
		};
		
		try
		{
			ModalContext.run(operation, false, new NullProgressMonitor(), getShell().getDisplay());
		}
		catch(Exception e)
		{
			return false;
		}
		finally
		{
			parent.setCursor(null);
		}
		
		if(TestUIPlugin.getInstance().getPreferenceStore().getBoolean(TestUI.OPEN_EDITOR))
		{
			for (Iterator i = loader.getResources().iterator(); i.hasNext();)
				UIUtil.openEditor(EMFUtil.getWorkspaceFile((Resource)i.next()), TestUIExtension.GENERIC_TEST_SUITE_EDITOR_PART_ID, false);		
		}
		
		loader.dispose();
		return succeed;
	}

	/*
	 * @see IWizard#performCancel()
	 */
	public boolean performCancel()
	{
		boolean res = false;

		res = super.performCancel();

		return res;
	}	
}