/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.internal.junit.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.test.common.junit.HyadesTestUtil;
import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.http.internal.util.HttpConstants;
import org.eclipse.hyades.test.http.internal.util.RequestHelper;
import org.eclipse.hyades.test.ui.internal.editor.extension.IWriteAccessChangeListener;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;


/**
 * @author marcelop
 * @since 1.0.2
 */
public class HttpTestCaseDetailPage 
extends DetailSection.DetailPage implements ModifyListener, IWriteAccessChangeListener
{
	private CCombo methodCombo;
	
	private StyledText httpVersionText;
	private StyledText hostText;
	private StyledText portText;
	private StyledText absolutePathText;
	private StyledText bodyText;
	private HttpHeaderViewer headerViewer;

	private RequestHelper requestHelper;
    
    /**
     * Constructor for HttpTestCaseDetailPage
     */
    public HttpTestCaseDetailPage()
    {
		requestHelper = new RequestHelper();
    }
    
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		getEditorForm().getBaseEditorExtension().removeListener(this);
		requestHelper.dispose();
		headerViewer.dispose();
	}
    
    /**
     * @see org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection.DetailPage#createControl(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory)
     */
	public Control createControl(Composite parent, FormWidgetFactory factory)
	{
		getEditorForm().getBaseEditorExtension().addListener(this);

		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();
		Composite composite = widgetFactory.createComposite(parent);
		composite.setLayout(new GridLayout());

		widgetFactory.createLabel(composite, TestHttpPlugin.getString("HTTP_Version_Label"));
		httpVersionText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
					 			
		widgetFactory.createLabel(composite, TestHttpPlugin.getString("RQ_METH_TEXT"));
		methodCombo = widgetFactory.createCCombo(composite, SWT.FLAT);
		methodCombo.setLayoutData(GridDataUtil.createHorizontalFill());
		methodCombo.setItems(HttpConstants.SUPPORTED_REQUEST_METHODS);
				
		widgetFactory.createLabel(composite, TestHttpPlugin.getString("HOST_TEXT"));
		hostText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		hostText.setLayoutData(GridDataUtil.createHorizontalFill());

		widgetFactory.createLabel(composite, TestHttpPlugin.getString("PORT_TEXT"));
		portText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		portText.setLayoutData(GridDataUtil.createHorizontalFill());

		widgetFactory.createLabel(composite, TestHttpPlugin.getString("ABS_PATH_TEXT"));
		absolutePathText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		absolutePathText.setLayoutData(GridDataUtil.createHorizontalFill());
					
		widgetFactory.createLabel(composite, TestHttpPlugin.getString("BODY_TEXT"));
		bodyText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.MULTI | SWT.V_SCROLL | SWT.H_SCROLL);
		GridData gridData = GridDataUtil.createHorizontalFill();
		gridData.heightHint = 4*hostText.getLineHeight();
		bodyText.setLayoutData(gridData);

		headerViewer = new HttpHeaderViewer();
		headerViewer.createControl(composite, widgetFactory);
		headerViewer.setReadOnly(isReadOnly());

		widgetFactory.paintBordersFor(composite);
		return composite;
	}
		
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection.DetailPage#setInput(java.lang.Object)
	 */
	public void setInput(Object object)
	{
		requestHelper.dispose();

		methodCombo.removeModifyListener(this);
		httpVersionText.removeVerifyKeyListener(this);
		httpVersionText.removeModifyListener(this);
		hostText.removeVerifyKeyListener(this);
		hostText.removeModifyListener(this);
		absolutePathText.removeVerifyKeyListener(this);
		absolutePathText.removeModifyListener(this);
		bodyText.removeVerifyKeyListener(this);
		bodyText.removeModifyListener(this);
		portText.removeVerifyKeyListener(this);
		portText.removeModifyListener(this);

		httpVersionText.setText("");
		hostText.setText("");
		bodyText.setText("");
		portText.setText("");
		absolutePathText.setText("");			
		methodCombo.setText("");

		if(object instanceof IStructuredSelection)
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)object;
			if(structuredSelection.size() == 1)
				object = structuredSelection.getFirstElement();
		}

		if(object instanceof ITestCase)
		{
			methodCombo.setEnabled(!isReadOnly());
						
			httpVersionText.setEditable(false);
			hostText.setEditable(true);
			bodyText.setEditable(true);
			absolutePathText.setEditable(true);
			portText.setEditable(true);

			requestHelper.setTestCase((ITestCase)object);
			httpVersionText.setText(HttpConstants.HTTP_VERSION);
			absolutePathText.setText(HyadesTestUtil.getNotNullString(requestHelper.getAttribute(RequestHelper.ATT_ABS_PATH)));
			bodyText.setText(HyadesTestUtil.getNotNullString(requestHelper.getAttribute(RequestHelper.ATT_BODY)));
			hostText.setText(HyadesTestUtil.getNotNullString(requestHelper.getAttribute(RequestHelper.ATT_HOST)));
			portText.setText(HyadesTestUtil.getNotNullString(requestHelper.getAttribute(RequestHelper.ATT_PORT)));
			methodCombo.setText(HyadesTestUtil.getNotNullString(requestHelper.getAttribute(RequestHelper.ATT_METHOD)));
			
			headerViewer.setEnabled(true);
			headerViewer.setInput(requestHelper);			
		}
		else
		{
			httpVersionText.setEditable(false);
			hostText.setEditable(false);
			bodyText.setEditable(false);
			absolutePathText.setEditable(false);
			methodCombo.setEnabled(false);
			portText.setEditable(false);
			
			headerViewer.setEnabled(false);
		}
		
		methodCombo.addModifyListener(this);
		httpVersionText.addVerifyKeyListener(this);
		httpVersionText.addModifyListener(this);
		hostText.addVerifyKeyListener(this);
		hostText.addModifyListener(this);
		absolutePathText.addVerifyKeyListener(this);
		absolutePathText.addModifyListener(this);
		bodyText.addVerifyKeyListener(this);
		bodyText.addModifyListener(this);
		portText.addVerifyKeyListener(this);
		portText.addModifyListener(this);		
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseEditorSection#getInput()
	 */
	public Object getInput()
	{
		return requestHelper.getTestCase();
	}
	
	/**
	 * @see org.eclipse.swt.custom.VerifyKeyListener#verifyKey(org.eclipse.swt.events.VerifyEvent)
	 */
	public void verifyKey(VerifyEvent event)
	{
		super.verifyKey(event);
		if(event.widget == portText)
			UIUtil.integerStyledTextVerifyKey(event);
	}

	/**
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
	 */
	public void modifyText(ModifyEvent e)
	{
		if(e.widget == absolutePathText)
			requestHelper.setAttribute(RequestHelper.ATT_ABS_PATH, absolutePathText.getText());
		
		else if(e.widget == bodyText)
			requestHelper.setAttribute(RequestHelper.ATT_BODY, bodyText.getText());
		
		else if(e.widget == hostText)
			requestHelper.setAttribute(RequestHelper.ATT_HOST, hostText.getText());

		else if(e.widget == portText)
			requestHelper.setAttribute(RequestHelper.ATT_PORT, portText.getText());

		else if(e.widget == methodCombo)
			requestHelper.setAttribute(RequestHelper.ATT_METHOD, methodCombo.getText());
			
		if(requestHelper.isDirty())
			getEditorForm().getBaseEditorExtension().markDirty();
	}	

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.extension.IWriteAccessChangeListener#writeAccessChanged(org.eclipse.core.resources.IFile, boolean)
	 */
	public void writeAccessChanged(IFile file, boolean isReadOnly)
	{
		methodCombo.setEnabled(!isReadOnly);
		headerViewer.setReadOnly(isReadOnly);
	}
}
