/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.test;

import junit.framework.TestSuite;

import org.eclipse.hyades.ui.test.util.CoreUtilTest;
import org.eclipse.hyades.ui.test.util.FileUtilTest;
import org.eclipse.hyades.ui.test.util.IDGeneratorTest;
import org.eclipse.hyades.ui.test.util.StringUtilTest;

/**
 * Test suite class for the Hyades UI common classes.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class UtilTest 
extends TestSuite
{
	/**
	 * Constructor for ExtensionTest
	 */
	public UtilTest()
	{
		super("Hyades UI Util");
		
		addTest(StringUtilTest.suite());
		addTest(CoreUtilTest.suite());
		addTest(FileUtilTest.suite());
		addTest(IDGeneratorTest.suite());
	}
}
