/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.manual.internal.codegen;

import java.io.ByteArrayInputStream;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.internal.codegen.Generator;
import org.eclipse.hyades.test.common.internal.codegen.Helper;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class ManualGenerator 
extends Generator
{
	/**
	 * @see org.eclipse.hyades.test.common.internal.codegen.Generator#generateFile(org.eclipse.hyades.models.common.facades.behavioral.ITestSuite, org.eclipse.core.resources.IFile, org.eclipse.core.runtime.IProgressMonitor)
	 */
	protected void generateFile(ITestSuite testSuite, IFile file, IProgressMonitor monitor)
	throws Exception
	{
		file.create(new ByteArrayInputStream(generateScript(testSuite).getBytes("UTF-8")), true, monitor);
	}
	
	public static String generateScript(ITestSuite testSuite)
	{
		GenTestSuite genTestSuite = new GenTestSuite();
		String script = genTestSuite.generate(testSuite, new Helper());
		
		String extraChars = "\t\t" + genTestSuite.NL;
		if(script.startsWith(extraChars))
			script = script.substring(extraChars.length());
		
		return script;
	}
}
