/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;

import java.util.Iterator;


/**
 * A plugin extension reader that populates the
 * loaders registry.
 * Clients are not expected to use this class directly.
 */
class LookupServiceRegistryReader extends RegistryReader {
    //~ Static fields/initializers -----------------------------------------------------------------

    static final String TAG_LOADER = "lookupService";
    static final String ATT_CLASS = "class";

    //~ Constructors -------------------------------------------------------------------------------

    public LookupServiceRegistryReader() {
        super(Platform.getPluginRegistry(), HierarchyPlugin.getPlugin().getDescriptor().getUniqueIdentifier(), HierarchyPlugin.LOOKUP_SERVICE_PPID);
    }

    //~ Methods ------------------------------------------------------------------------------------

    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equals(TAG_LOADER)) {
            if (element.getAttribute(ATT_CLASS) == null) {
                logMissingAttribute(element, ATT_CLASS);
            } else {
                try {
                    PluginClassDescriptor classDescriptor = new PluginClassDescriptor(element, ATT_CLASS);
                    LookupService lookupService = (LookupService) classDescriptor.createInstance();

                    if (lookupService != null) {
                        //reuse instances of the lookup service
                        for (Iterator iter = LookupServiceExtensions.getInstance().values().iterator();
                                 iter.hasNext();) {
                            LookupService l = (LookupService) iter.next();

                            if (element.getClass() == lookupService.getClass()) {
                                lookupService = l;

                                break;
                            }
                        }

                        for (Iterator iter = lookupService.getSupportedTypes().iterator();
                                 iter.hasNext();) {
                            Class type = (Class) iter.next();

                            LookupServiceExtensions.getInstance().put(type, lookupService);
                        }
                    } else {
                        logError(element, "Error when creating instance of lookup service: " + element.getAttribute(ATT_CLASS));
                    }
                } catch (Exception e) {
                    logError(element, e.getLocalizedMessage());
                }

                return true;
            }
        }

        return false;
    }
}
